/**
 *  除继承样式外， app.wxss 中的样式、组件所在页面的的样式对自定义组件无效。
 *  参考文档：https://developers.weixin.qq.com/miniprogram/dev/framework/custom-component/wxml-wxss.html
 *  采用 externalClasses 的方式 在组件.wxml需要的view的class加super-class，可以是多个
 *  使用 <Component super-class="<#type#>" />
 */

Component({
  properties: {
    showDelect: Boolean,
    flexList: Array,
    title: String // 简化的定义方式
  },
  externalClasses: ["flex", "flex-c", "flex-j-c", "flex-w", "flex-a-c"],
  data: {
    list: [
      {
        title: "优惠卷",
        icon: "../../images/waitpay.png",
        subTitle: "活动优惠卷"
      },
      {
        title: "奖品",
        icon: "../../images/waitsent.png",
        subTitle: "丰富奖品"
      },
      {
        title: "生日礼品",
        icon: "../../images/waitpick.png",
        subTitle: "会员生日惊喜"
      },
      {
        title: "营销活动",
        icon: "../../images/unReview.png",
        subTitle: "营销活动"
      }
    ]
  },
  methods: {
    // 这里是一个自定义方法
    tagAction(e) {
      var eventOption = { content: e.currentTarget.dataset.text }; // 触发事件的选项
      this.triggerEvent("tagClick", eventOption);
    }
  }
});
