// pages/Cart/index.js
Page({
  /**
   * 页面的初始数据
   */
  data: {
    goodsList: [],
    loading: true,
    selectCount: 0,
    selectGoodsSource: [],
    imageUrl: "../../images/640.jpeg",
    imageIcon: "../../images/group_portrait.png",
    isSelectAll: false,
    totalPrice: 0,
    slideButtons: [
      {
        type: "warn",
        text: "删除",
        extClass: "test",
        src: "icon_del.svg" // icon的路径
      }
    ]
  },
  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function() {
    this.loadNewData();
  },
  loadMoreData() {
    let goods = this.data.goodsList;
    for (let index = 0; index < 7; index++) {
      goods.push({
        isSelect: false,
        goodsPrice: (199 % 3) + index,
        goodsCount: index + 1,
        goodsUrl:
          index % 2
            ? "../../images/group_portrait.png "
            : "../../images/640.jpeg",
        goodsName: "90分户外休闲中长厚款鹅绒羽绒服" + index,
        goodsSpec: "XL;黑色 2" + index
      });
    }
    this.setData({
      goodsList: goods
    });
    wx.stopPullDownRefresh();
  },
  loadNewData() {
    this.data.goodsList = [];
    this.loadMoreData();
  },
  orderAction(e) {
    wx.navigateTo({
      url: "../Order/index"
    });
    // let selectCount = this.data.selectCount
    // if (selectCount <= 0) {
    //   return
    // }
    // let totalPrice = this.data.totalPrice
    // wx.showModal({
    //   content: '购买'+selectCount+'件商品\n'+'总价为：'+totalPrice+'的商品',
    //   success: (res) => {
    //     if (res.confirm) {
    //       this.showToast("购买成功!!")
    //     }
    //   }
    // })
  },
  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {
    this.loadNewData();
    this.setData({
      isSelectAll: false,
      selectGoodsSource: [],
      totalPrice: 0,
      selectCount: 0
    });
  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {
    // this.loadMoreData()
  },
  delectGoods(index) {
    if (index >= this.data.goodsList.length) {
      console.log("大于数量", index);
      return;
    }
    var goodsList = this.data.goodsList;
    let goods = goodsList[index];

    goodsList.splice(index, 1);

    let selectGoodsSource = this.data.selectGoodsSource.filter(item => {
      if (item.goodsName != goods.goodsName) {
        return item;
      }
    });

    var totalPrice = this.data.totalPrice;
    var selectCount = this.data.selectCount;
    if (goods.isSelect) {
      totalPrice = totalPrice - goods.goodsCount * goods.goodsPrice;
      selectCount = selectGoodsSource.length;
    }
    var isSelectAll = this.data.isSelectAll;
    if (selectGoodsSource.length == 0) {
      isSelectAll = false;
    }
    this.setData({
      isSelectAll: isSelectAll,
      goodsList: goodsList,
      selectGoodsSource: selectGoodsSource,
      totalPrice: totalPrice,
      selectCount: selectCount
    });
  },
  slideButtonTap(e) {
    const index = e.currentTarget.dataset.index;
    this.delectGoods(index);
  },
  allSelectAction() {
    var isSelectAll = !this.data.isSelectAll;
    var selectGoodsSource = [];
    if (!isSelectAll) {
      this.data.totalPrice = 0;
      for (let i = 0; i < this.data.goodsList.length; i++) {
        let goods = this.data.goodsList[i];
        goods.isSelect = isSelectAll;
      }
    } else {
      var unSelectGoods = this.data.goodsList.filter(
        goods => goods.isSelect != isSelectAll
      );
      for (let i = 0; i < unSelectGoods.length; i++) {
        let goods = unSelectGoods[i];
        goods.isSelect = isSelectAll;
        this.data.totalPrice =
          this.data.totalPrice + goods.goodsPrice * goods.goodsCount;
        selectGoodsSource.push(goods);
      }
    }
    let goodsList = this.data.goodsList;
    let selectCount = selectGoodsSource.length;
    const totalPrice = this.data.totalPrice;
    this.setData({
      isSelectAll: isSelectAll,
      selectGoodsSource: selectGoodsSource,
      goodsList: goodsList,
      selectCount: selectCount,
      totalPrice: totalPrice
    });
  },
  selectGoodsAction(e) {
    const index = e.currentTarget.dataset.index;
    const goods = this.data.goodsList[index];
    goods.isSelect = !goods.isSelect;
    var selectGoodsSource = this.data.selectGoodsSource;
    var totalPrice = this.data.totalPrice;
    if (goods.isSelect) {
      totalPrice = totalPrice + goods.goodsCount * goods.goodsPrice;
      selectGoodsSource.push(goods);
    } else {
      totalPrice = totalPrice - goods.goodsCount * goods.goodsPrice;
      selectGoodsSource = this.data.selectGoodsSource.filter(item => {
        if (item.goodsName != goods.goodsName) {
          return item;
        }
      });
    }

    let goodsList = this.data.goodsList;
    let isSelectAll = selectGoodsSource.length == goodsList.length;
    this.setData({
      isSelectAll: isSelectAll,
      selectGoodsSource: selectGoodsSource,
      goodsList: goodsList,
      selectCount: selectGoodsSource.length,
      totalPrice: totalPrice
    });
  },
  addBtnTap(e) {
    let goodsList = this.data.goodsList;
    const index = e.currentTarget.dataset.index;
    const goods = goodsList[index];
    goods.goodsCount += 1;
    let totalPrice = this.data.totalPrice;
    totalPrice = totalPrice + goods.goodsPrice;

    this.setData({
      goodsList: goodsList,
      totalPrice: totalPrice
    });
  },
  inputAction(e) {
    const goodsCount = e.detail.value;
    if (goodsCount >= 99) {
      wx.showToast({
        title: "超出库存数！",
        duration: 1500,
        complete: () => {
          let goodsList = this.data.goodsList;
          this.setData({
            goodsList: goodsList
          });
        }
      });
      return;
    }
    const index = e.currentTarget.dataset.index;
    this.data.goodsList[index].goodsCount = goodsCount;
    this.setData({
      goodsList: this.data.goodsList
    });
  },
  reduceBtnTap(e) {
    let goodsList = this.data.goodsList;
    const index = e.currentTarget.dataset.index;
    const goods = goodsList[index];
    const number = goods.goodsCount - 1;

    if (number <= 0) {
      // 弹出删除确认
      wx.showModal({
        content: "确定要删除该商品吗？",
        success: res => {
          if (res.confirm) {
            this.delectGoods(index);
          }
        }
      });
      return;
    }
    let totalPrice = this.data.totalPrice;
    if (goods.isSelect) {
      totalPrice = totalPrice - goods.goodsPrice;
    }
    goods.goodsCount = number;
    this.setData({
      goodsList: goodsList,
      totalPrice: totalPrice
    });
  },
  showToast(text) {
    wx.showToast({
      title: text,
      duration: 1500
    });
  }
});
