Page({
  /**
   * 页面的初始数据
   */
  data: {
    i: 0,
    loading: true,
    imageUrl: "../../images/640.jpeg",
    imageIcon: "../../images/group_portrait.png",
    bannerList: ["../../images/640.jpeg", "../../images/640.jpeg"],
    classifications: [
      "居家",
      "鞋包配饰",
      "服装",
      "电器",
      "婴童",
      "饮食",
      "特色区",
      "洗护",
      "餐厨",
      "文体"
    ],
    activityList: [
      {
        icon: "../../images/640.jpeg",
        text: "新品热销榜",
        subText: "热销爆款不容错过",
        id: 1
      },
      {
        icon: "../../images/640.jpeg",
        text: "新品热销榜",
        subText: "热销爆款不容错过",
        id: 2
      },
      {
        icon: "../../images/640.jpeg",
        text: "新品热销榜",
        subText: "热销爆款不容错过",
        id: 3
      },
      {
        icon: "../../images/640.jpeg",
        text: "新品热销榜",
        subText: "热销爆款不容错过",
        id: 4
      }
    ],
    iconList: []
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    // this.setData({
    //     search: this.search.bind(this)
    // })
    setTimeout(() => {
      this.setData({
        loading: false
      });
      this.loadNewData();
    }, 2000);
  },
  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {},

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {},

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function() {},
  loadNewData: function() {
    this.data.iconList = [];
    this.loadMoreData();
  },
  loadMoreData: function() {
    let list = this.data.iconList;
    for (let index = 0; index < 20; index++) {
      list.push({
        icon:
          index % 2 ? "../../images/plus_dark.png" : "../../images/640.jpeg",
        text: "琴岛智能除螨电热毯 安全定时 智能控温" + index,
        price: 171 + index
      });
    }
    this.setData({
      iconList: list
    });
  },
  /**
   * 用户搜索
   */
  selectAction: function(e) {
    wx.navigateTo({
      url: "../Search/index"
    });
  },
  cellAction: function(e) {
    this.showToastText("点击了" + e.currentTarget.dataset["index"]);
    console.log("cellAction result", e.currentTarget.dataset["index"]);
  },
  classificationAction: function(e) {
    this.showToastText("点击了" + e.currentTarget.dataset["index"]);
    console.log(
      "classificationAction result",
      e.currentTarget.dataset["index"]
    );
  },
  onPullDownRefresh: function(e) {
    this.loadNewData();
    console.log("onPullDownRefresh result", this.data.iconList);
  },
  onReachBottom: function(e) {
    this.loadMoreData();
    console.log("onReachBottom result", this.data.iconList);
  },
  showToastText: function(text) {
    wx.showToast({
      title: text,
      icon: "success",
      duration: 2000
    });
  }
});
