// pages/Home/index.js
const windowHeight = wx.getSystemInfoSync().windowHeight
const windowWidth = wx.getSystemInfoSync().windowWidth
const colorLight = 'rgba(0, 0, 0, .9)'
const colorDark = 'rgba(255, 255, 255, .8)'

Page({

  /**
   * 页面的初始数据
   */
  data: {
    windowHeight: windowHeight,
    windowWidth: windowWidth,
    inputShowed: false,
    inputVal: "",
    i: 0,
    indicatorDots: true,
    vertical: false,
    autoplay: false,
    interval: 2000,
    duration: 500,
    imageUrl:'../../image/640.jpeg',
    imageIcon:'../../image/group_portrait.png',
    bannerList:['../../image/640.jpeg','../../image/640.jpeg'],
    classifications:["居家","鞋包配饰","服装", "电器","婴童","饮食", "特色区","洗护","餐厨","文体"],
    activityList:[{
      icon: '../../image/640.jpeg',
      text: "新品热销榜",
      subText: "热销爆款不容错过",
      id: 1
    },{
      icon: '../../image/640.jpeg',
      text: "新品热销榜",
      subText: "热销爆款不容错过",
      id: 2
    },{
      icon: '../../image/640.jpeg',
      text: "新品热销榜",
      subText: "热销爆款不容错过",
      id: 3
    },{
      icon: '../../image/640.jpeg',
      text: "新品热销榜",
      subText: "热销爆款不容错过",
      id: 4
    },],
    iconList:[]
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
        // this.setData({
        //     search: this.search.bind(this)
        // })
        this.loadNewData()
  },
  search: function (value) {
    return new Promise((resolve, reject) => {
        if (this.data.i % 2 === 0) {
            setTimeout(() => {
                resolve([{text: '搜索结果', value: 1}, {text: '搜索结果2', value: 2}])
            }, 200)
        } else {
            setTimeout(() => {
                resolve([])
            }, 200)

        }
        this.setData({
            i: this.data.i + 1
        })
    })
},

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function () {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  },
  loadNewData: function() {
    this.data.iconList = []
    this.loadMoreData()
  },
  loadMoreData: function() {
    let list = this.data.iconList;
    for (let index = 0; index < 20; index++) {
      list.push({
        icon: (index % 2)?'../../image/plus_dark.png':'../../image/640.jpeg',
        text: "琴岛智能除螨电热毯 安全定时 智能控温" + index,
        price: (171 + index)
      })
    }
    this.setData({
      iconList: list,
    });
  },
  /**
   * 用户搜索
   */
  selectAction: function (e) {
    this.showToastText('搜索成功！！')
    console.log('select result', e)
  },
  cellAction:function (e) {
    this.showToastText('点击了'+e.currentTarget.dataset['index'])
    console.log('cellAction result', e.currentTarget.dataset['index'])
  },
  classificationAction: function(e) {
    this.showToastText('点击了'+e.currentTarget.dataset['index'])
    console.log('classificationAction result', e.currentTarget.dataset['index'])
  },
  onPullDownRefresh: function(e) {
    this.loadNewData()
    console.log('onPullDownRefresh result', this.data.iconList)
  },
  onReachBottom: function(e) {
    this.loadMoreData()
    console.log('onReachBottom result',this.data.iconList)
  },
  showToastText: function(text) {
    wx.showToast({
      title: text,
      icon: 'success',
      duration: 2000
    })
  }
})