/**
 *  除继承样式外， app.wxss 中的样式、组件所在页面的的样式对自定义组件无效。
 *  参考文档：https://developers.weixin.qq.com/miniprogram/dev/framework/custom-component/wxml-wxss.html
 *  采用 externalClasses 的方式 在组件.wxml需要的view的class加super-class，可以是多个
 *  使用 <Component super-class="<#type#>" />
 */

let App = getApp();

Component({
  properties: {
    showDelect: Boolean,
    flexList: Array,
    title: String // 简化的定义方式
  },
  externalClasses: [
    "flex",
    "flex-j-b",
    "flex-c",
    "text-c",
    "flex-a-c",
    "flex-j-a",
    "flex-j-c"
  ],
  data: {
    content: "content",
    list: [
      { title: "待付款", icon: "../../images/waitpay.png", count: 0 },
      { title: "待发货", icon: "../../images/waitsent.png", count: 1 },
      { title: "待收货", icon: "../../images/waitpick.png", count: 2 },
      { title: "待评价", icon: "../../images/unReview.png", count: 0 },
      { title: "退换货", icon: "../../images/waitsent.png", count: 1 }
    ]
  },
  methods: {
    // 这里是一个自定义方法
    tagAction(e) {
      let item = this.data.list[e.detail.idx];
      if (item.count > 0) {
        item.count = 0;
      } else {
        item.count = Math.ceil(Math.random() * 15);
      }
      console.log(item);
      App.toastText(item.title);
      this.setData({
        list: this.data.list
      });
      // var eventOption = { content: e.currentTarget.dataset.text }; // 触发事件的选项
      // this.triggerEvent("tagClick", eventOption);
    }
  }
});
