/*
 * @Author: your name
 * @Date: 2020-12-25 11:16:04
 * @LastEditTime: 2020-12-31 16:01:22
 * @LastEditors: Please set LastEditors
 * @Description: In User Settings Edit
 * @FilePath: /ChengjingPremiumMember/src/components/UserService/index.js
 */
/**
 *  除继承样式外， app.wxss 中的样式、组件所在页面的的样式对自定义组件无效。
 *  参考文档：https://developers.weixin.qq.com/miniprogram/dev/framework/custom-component/wxml-wxss.html
 *  采用 externalClasses 的方式 在组件.wxml需要的view的class加super-class，可以是多个
 *  使用 <Component super-class="<#type#>" />
 */

let App = getApp();

Component({
  properties: {
    showDelect: Boolean,
    flexList: Array,
    title: String // 简化的定义方式
  },
  externalClasses: ["flex", "flex-c", "flex-j-c", "flex-w", "flex-a-c"],
  data: {
    list: [
      { title: "积分商城", icon: "../../images/integral.png" },
      { title: "余额", icon: "../../images/balance.png" },
      { title: "充值", icon: "../../images/recharge.png" },
      { title: "绑定老卡", icon: "../../images/value_card.png" },
      { title: "会员信息", icon: "../../images/memInfo.png" },
      { title: "附近门店", icon: "../../images/stores.png" },
      { title: "预约", icon: "../../images/reservation.png" },
      { title: "客服中心", icon: "../../images/service.png" },
      { title: "收藏", icon: "../../images/favorite.png" },
      { title: "账户安全", icon: "../../images/waitsent.png" },
      { title: "系统消息", icon: "../../images/sys_news.png" },
      { title: "消费查询", icon: "../../images/waitsent.png" }
    ]
  },
  methods: {
    // 这里是一个自定义方法
    tagAction(e) {
      let item = this.data.list[e.detail.idx];
      console.log(item);
      App.toastText(item.title);

      // var eventOption = { content: e.currentTarget.dataset.text }; // 触发事件的选项
      // this.triggerEvent("tagClick", eventOption);
    }
  }
});
