const formatTime = date => {
  const year = date.getFullYear();
  const month = date.getMonth() + 1;
  const day = date.getDate();
  const hour = date.getHours();
  const minute = date.getMinutes();
  const second = date.getSeconds();

  return (
    [year, month, day].map(formatNumber).join("/") +
    " " +
    [hour, minute, second].map(formatNumber).join(":")
  );
};

const formatNumber = n => {
  n = n.toString();
  return n[1] ? n : "0" + n;
};

function beforeFn(fn, inject) {
  return (...args) => {
    try {
      inject(...args);
      fn.call(this, ...args);
    } catch (error) {
      console.warn(error);
      fn.call(this, ...args);
    }
  };
}
function afterFn(fn, inject) {
  return (...args) => {
    try {
      fn.call(this, ...args);
      inject(...args);
    } catch (error) {
      console.warn(error);
      fn.call(this, ...args);
    }
  };
}

module.exports = {
  formatTime,
  beforeFn,
  afterFn
};
