//
//  AppDelegate+UIViewController.m
//  Mall-iOS
//
//  Created by Nemo on 2020/10/21.
//

#import "AppDelegate+UIViewController.h"
#import <NMCategories/NMCategories.h>
#import <QMUIKit/QMUIKit.h>
#import <NMTheme/NMTheme.h>
#import "NMRouter+CartModuleActions.h"
#import "NMRouter+HomeModuleActions.h"

@implementation AppDelegate (UIViewController)

- (void)viewControllerApplication:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    

    [self initViewController];
    
    [self initStyle];
    
    [self startLaunchingAnimation];
}

- (void)initStyle {
    
    [[UIButton appearance] setExclusiveTouch:YES];
    if (@available(iOS 11.0, *)){
        //[UITableView appearance].contentInsetAdjustmentBehavior = UIScrollViewContentInsetAdjustmentNever;
        [UITableView appearance].estimatedRowHeight = 0;
        [UITableView appearance].estimatedSectionHeaderHeight = 0;
        [UITableView appearance].estimatedSectionFooterHeight = 0;
        [UITableView appearance].backgroundColor = UIColor.nm_backgroundColor;
    }else {
        self.window.rootViewController.automaticallyAdjustsScrollViewInsets = NO;
    }
}

- (void)initViewController {
    UITabBarController *tab = [[UITabBarController alloc] init];

    UIViewController *home = [[NMRouter sharedInstance] jyMediatorHomeViewController];
    UIViewController *shopping = [[NMRouter sharedInstance] jyMediatorCartViewController];

    tab.viewControllers = @[home,shopping];

    self.window.rootViewController = tab;
    [self.window makeKeyAndVisible];
}


- (void)startLaunchingAnimation {
    UIWindow *window = self.window;
    UIStoryboard *storyboard = [UIStoryboard storyboardWithName:@"LaunchScreen" bundle:[NSBundle mainBundle]];
    UIViewController *rootVC = [storyboard instantiateInitialViewController];
    UIView *launchScreenView = rootVC.view;
    launchScreenView.backgroundColor = UIColor.clearColor;
    //launchScreenView.frame = window.bounds;
    [window addSubview:launchScreenView];
    
    UIImageView *backgroundImageView = launchScreenView.subviews.firstObject;
    backgroundImageView.clipsToBounds = YES;
    
    /**
     UIImageView *logoImageView = launchScreenView.subviews[1];
     UILabel *copyrightLabel = launchScreenView.subviews.lastObject;
     */
    UIView *maskView = [[UIView alloc] initWithFrame:launchScreenView.bounds];
    maskView.backgroundColor = UIColor.nm_tintColor;
    [launchScreenView insertSubview:maskView belowSubview:backgroundImageView];
    
    [launchScreenView layoutIfNeeded];
    
    
    [launchScreenView.constraints enumerateObjectsUsingBlock:^(__kindof NSLayoutConstraint * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        NSLog(@"%@",obj.identifier);
        if ([obj.identifier isEqualToString:@"bottomAlign"]) {
            obj.active = NO;
            [NSLayoutConstraint constraintWithItem:backgroundImageView attribute:NSLayoutAttributeBottom relatedBy:NSLayoutRelationEqual toItem:launchScreenView attribute:NSLayoutAttributeTop multiplier:1 constant:NavigationContentTop].active = YES;
            *stop = YES;
        }
    }];
    
    
    [UIView animateWithDuration:.15 delay:0.9 options:QMUIViewAnimationOptionsCurveOut animations:^{
         [launchScreenView layoutIfNeeded];
         //logoImageView.alpha = 0.0;
         //copyrightLabel.alpha = 0;
    } completion:nil];

    
    [UIView animateWithDuration:1.2 delay:0.9 options:UIViewAnimationOptionCurveEaseOut animations:^{
        maskView.alpha = 0;
        backgroundImageView.alpha = 0;
    } completion:^(BOOL finished) {
        [launchScreenView removeFromSuperview];
    }];
}

@end
