//
//  CounterView.m
//  Mall-iOS
//
//  Created by Nemo on 2020/10/13.
//

#import "CounterView.h"
#import <NMCategories/NMCategories.h>
#import <Masonry/Masonry.h>
#import <QMUIKit.h>

@interface CounterView()<UITextFieldDelegate>
@property (nonatomic, strong) UITextField *countTF;
@property (nonatomic, strong) UIView *keyboardConfirmView;
@property (nonatomic, strong) UIView *keyboardBackgroundView;
@property (nonatomic, strong) UIButton *confirmBtn;
@property (nonatomic, strong) UIButton *moreBtn;
@property (nonatomic, strong) UIButton *lessBtn;
@end

@implementation CounterView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    
    [self.moreBtn setImage:[UIImage imageNamed:@"goods_detail_more"] forState:UIControlStateNormal];
    [self.lessBtn setImage:[UIImage imageNamed:@"goods_detail_less"] forState:UIControlStateNormal];


}
- (void)keyboardWillChangeFrame:(NSNotification *)notification{
    
    NSDictionary *userInfo = notification.userInfo;
    CGFloat duration = [userInfo[UIKeyboardAnimationDurationUserInfoKey] doubleValue];
    CGRect endFrame = [userInfo[UIKeyboardFrameEndUserInfoKey] CGRectValue];

    NSLog(@"%f  %@",duration,NSStringFromCGRect(endFrame));
    
    if (!_keyboardBackgroundView.hidden) {
        [kGetLastWindow() addSubview:self.keyboardBackgroundView];
    }else{
        self.keyboardBackgroundView.hidden = NO;
    }
    
    [self keyboardToolViewAnimationDistance:SCREEN_HEIGHT-44-endFrame.size.height];
}

#pragma mark -- business logic

- (BOOL)textFieldShouldBeginEditing:(UITextField *)textField {
    
    [KNOTE() addObserver:self selector:@selector(keyboardWillChangeFrame:) name:UIKeyboardWillShowNotification object:nil];
    
    return YES;;
}

- (void)inputFinishAction {
    
    NSInteger count = [self.countTF.text integerValue];
    _count = count;
    !self.countChangeAction ?: self.countChangeAction(_count);
    [self keyboardTapAction];
}
- (void)keyboardTapAction {
    self.keyboardBackgroundView.hidden = YES;
    [self.countTF resignFirstResponder];
    [self keyboardToolViewAnimationDistance:SCREEN_HEIGHT-44];
    [KNOTE() removeObserver:self name:UIKeyboardWillShowNotification object:nil];

}

- (void)keyboardToolViewAnimationDistance:(CGFloat)distance {
    
    NSLog(@"%f",distance);

    [UIView animateWithDuration:0.25 animations:^{
        self.keyboardConfirmView.qmui_top = distance;
    } completion:^(BOOL finished) { }];
}

#pragma --mark set data

- (void)setCount:(NSInteger)count {
    _count = count;
    self.countTF.text = [NSString stringWithFormat:@"%ld",count];
}

- (void)lessAction:(UIButton *)sender {
    if (_count == 1) { return; }
    _count --;
    self.count = _count;
    !self.countChangeAction ?: self.countChangeAction(_count);
}

- (void)moreAction:(UIButton *)sender {
    _count ++;
    self.count = _count;
    !self.countChangeAction ?: self.countChangeAction(_count);

}

- (void)drawRect:(CGRect)rect {
    
    UIBezierPath *maskPath = [UIBezierPath bezierPathWithRoundedRect:rect byRoundingCorners:UIRectCornerAllCorners cornerRadii:CGSizeMake(3, 3)];
    CAShapeLayer *maskLayer = [[CAShapeLayer alloc]init];
    maskLayer.frame = rect;
    maskLayer.borderWidth = 2;
    maskLayer.borderColor = RGBCOLOR(221, 221, 221).CGColor;
    maskLayer.path = maskPath.CGPath;
    self.layer.mask = maskLayer;
    /**
     UIBezierPath *path = [UIBezierPath qmui_bezierPathWithRoundedRect:rect cornerRadiusArray:@[@3,@3,@3,@3] lineWidth:0];

     [[UIColor lightGrayColor] setFill];
     [path fill];
     
     CAShapeLayer *layer = [[CAShapeLayer alloc] init];
     layer.frame = rect;
     layer.path = path.CGPath;
     self.layer.mask = layer;
     */

}

#pragma mark lazy load

- (UIButton *)confirmBtn {
    if (_confirmBtn == nil) {
        _confirmBtn = [UIButton buttonWithType:UIButtonTypeSystem];
        [_confirmBtn setTitle:@"完成" forState:UIControlStateNormal];
        [_confirmBtn addTarget:self action:@selector(inputFinishAction) forControlEvents:UIControlEventTouchUpInside];
    }
    return _confirmBtn;
}

- (UIView *)keyboardConfirmView {
    if (_keyboardConfirmView == nil) {
        _keyboardConfirmView = [[UIView alloc] initWithFrame:CGRectMake(0, SCREEN_HEIGHT-44, SCREEN_WIDTH, 44)];
        _keyboardConfirmView.backgroundColor = RGBCOLOR(153, 153, 153);
        [self.keyboardBackgroundView addSubview:_keyboardConfirmView];
        [_keyboardConfirmView addSubview:self.confirmBtn];
        [_confirmBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerY.equalTo(self->_keyboardConfirmView);
            make.right.equalTo(self->_keyboardConfirmView).inset(31);
        }];
    }
    return _keyboardConfirmView;
}
- (UIView *)keyboardBackgroundView {
    if (_keyboardBackgroundView == nil) {
        _keyboardBackgroundView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT)];
        UITapGestureRecognizer *tag =[[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(keyboardTapAction)];
        [_keyboardBackgroundView addGestureRecognizer:tag];
    }
    return _keyboardBackgroundView;
}
- (UITextField *)countTF {
    if (_countTF == nil) {
        _countTF = [[UITextField alloc] init];
        _countTF.font = FONTSIZE(12);
        _countTF.textColor = RGBCOLOR(51, 51, 51);
        _countTF.textAlignment = NSTextAlignmentCenter;
        _countTF.keyboardType = UIKeyboardTypeNumberPad;
        _countTF.delegate = self;
        [self addSubview:_countTF];
        [_countTF mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.equalTo(self.moreBtn.mas_left);
            make.left.equalTo(self.lessBtn.mas_right);
            make.top.bottom.equalTo(self);
        }];
    }
    return _countTF;
}

- (UIButton *)moreBtn {
    if (_moreBtn == nil) {
        _moreBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [_moreBtn addTarget:self action:@selector(moreAction:) forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:_moreBtn];
        [_moreBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.width.height.mas_equalTo(30);
            make.right.top.equalTo(self);
        }];
    }
    return _moreBtn;
}

- (UIButton *)lessBtn {
    if (_lessBtn == nil) {
        _lessBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [_lessBtn addTarget:self action:@selector(lessAction:) forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:_lessBtn];
        [_lessBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.width.height.mas_equalTo(30);
            make.left.top.equalTo(self);
        }];
    }
    return _lessBtn;
}

- (void)dealloc {
    self.countTF.delegate = nil;
}

@end
