//
//  ShoppingCartViewController.m
//  Mall-iOS
//
//  Created by Nemo on 2020/10/12.
//

#import "ShoppingCartViewController.h"
#import "ShoppingCartCounterView.h"
#import <NMReactiveCocoa/ReactiveObjC.h>
#import <QMUIKit/QMUIKit.h>
#import <Masonry/Masonry.h>
#import <NMCategories/NMCategories.h>
#import <NMUIChainKit/NMUIChainKit.h>
#import "ShoppingCartCell.h"
#import "GoodsModel.h"

@interface ShoppingCartViewController ()<UITableViewDelegate,UITableViewDataSource>
@property (nonatomic, strong) ShoppingCartCounterView *shoppingCounterView;
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) NSMutableArray *dataSource;

/// 已选择的商品数组
@property (nonatomic, strong) NSMutableArray *selectGoodsSource;

@property (nonatomic, assign) CGFloat totalPrice;

@end

@implementation ShoppingCartViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setupUI];
    
    [self requstNewData];
}

-(void)setupUI {
    self.view.backgroundColor = [UIColor whiteColor];

    self.shoppingCounterView.selectCount = 0;
    self.shoppingCounterView.totalPrice = 0;
    self.shoppingCounterView.isSelectAll = NO;
    
//    [self.tableView reloadData];
}

- (void)requstNewData {
    
    for (int i  = 0; i < 7; i ++) {
        GoodsModel *model = [[GoodsModel alloc] init];
        model.isSelect = (i % 2) && (i < 6);
        model.goodsName = [NSString stringWithFormat:@"90分户外休闲中长厚款鹅绒羽绒服 %d",i];
        model.goodsSpec = [NSString stringWithFormat:@"XL;黑色 %d",i];
        model.goodsUrl = @"";
        model.goodsCount = i+1;
        model.goodsPrice = (i + 1) * (arc4random() % 100);
        [self.dataSource addObject:model];
        if (model.isSelect) {
            self.totalPrice += (model.goodsPrice*model.goodsCount);
            [self.selectGoodsSource addObject:model];
        }
    }
    self.title = [NSString stringWithFormat:@"购物车(%ld)",self.dataSource.count];
    [self goodsChangeAction];
    [self.tableView reloadData];
    
}


#pragma mark -- business logic

- (void)orderAction {
    NSMutableString *info = [NSMutableString string];
    
    CGFloat totalPrice = 0;
    for (GoodsModel *model in self.selectGoodsSource) {
        [info appendFormat:@"商品名：%@\n商品数量 ：%.f\n商品价:%.f\n",model.goodsName,model.goodsCount,model.goodsPrice];
        totalPrice += (model.goodsCount*model.goodsPrice);
    }
    [info appendFormat:@"总价:%f",totalPrice];
    [QMUITips showInfo:info inView:self.view hideAfterDelay:6];
}

- (void)selectAllGood:(BOOL)isSelect {
    if (!isSelect) {
        [self.selectGoodsSource removeAllObjects];
        self.totalPrice = 0;
        for (GoodsModel *model in self.dataSource) {
            model.isSelect = isSelect;
        }
    }else{
        NSPredicate *pre = [NSPredicate predicateWithFormat:@"self.isSelect = %d",!isSelect];
        NSArray *unSelectGoods = [self.dataSource filteredArrayUsingPredicate:pre];
        for (GoodsModel *model in unSelectGoods) {
            model.isSelect = isSelect;
            self.totalPrice += (model.goodsPrice*model.goodsCount);
            [self.selectGoodsSource addObject:model];
        }
    }

    [self.tableView reloadData];
    [self goodsChangeAction];
}

- (void)goodsChangeAction {
    
    self.shoppingCounterView.selectCount = self.selectGoodsSource.count;
    
    self.shoppingCounterView.isSelectAll = (self.dataSource.count == self.selectGoodsSource.count);
    
    self.shoppingCounterView.totalPrice = self.totalPrice;
    
}

- (void)changeGoodsCount:(GoodsModel *)model count:(NSInteger)count {

    if (count > 99) {
        [QMUITips showError:[NSString stringWithFormat:@"超出商品：%@的库存",model.goodsName] inView:self.view hideAfterDelay:2];
        NSInteger row = [self.dataSource indexOfObject:model];
        if (row < self.dataSource.count) {
            NSIndexPath *path = [NSIndexPath indexPathForRow:row inSection:0];
            [self.tableView reloadRowsAtIndexPaths:@[path] withRowAnimation:UITableViewRowAnimationNone];
        }else{
            [self.tableView reloadData];
        }
        return;
    }
    if (model.isSelect) {
        if (model.goodsCount > count) {
            self.totalPrice -= (model.goodsPrice*(model.goodsCount - count));
        }else{
            self.totalPrice += (model.goodsPrice*(count - model.goodsCount));

        }
        self.shoppingCounterView.totalPrice = self.totalPrice;
    }
    model.goodsCount = count;
    
    NSLog(@"总价：%.f",self.totalPrice);
}

- (void)selectGoods:(GoodsModel *)model isSelect:(BOOL)select{
    //NSLog(@"indexPath:%ld",indexPath.row);
    //GoodsModel *model = self.dataSource[indexPath.row];
    model.isSelect = select;
    if (select) {
        self.totalPrice += (model.goodsPrice*model.goodsCount);
        [self.selectGoodsSource addObject:model];
    }else{
        self.totalPrice -= (model.goodsPrice*model.goodsCount);
        [self.selectGoodsSource removeObject:model];
    }
    
    [self goodsChangeAction];
}

- (void)deleteIndex:(GoodsModel *)model {
    
    QMUIAlertAction *cancel = [QMUIAlertAction actionWithTitle:@"取消" style:QMUIAlertActionStyleCancel handler:NULL];
    @weakify(self);
    QMUIAlertAction *delete = [QMUIAlertAction actionWithTitle:@"删除" style:QMUIAlertActionStyleDestructive handler:^(__kindof QMUIAlertController * _Nonnull aAlertController, QMUIAlertAction * _Nonnull action) {
        @strongify(self);
        self.title = [NSString stringWithFormat:@"购物车(%ld)",self.dataSource.count];
        if (model.isSelect) {
            [self selectGoods:model isSelect:NO];
        }
        NSInteger row = [self.dataSource indexOfObject:model];
        [self.dataSource removeObject:model];
        if (row < self.dataSource.count) {
            NSIndexPath *path = [NSIndexPath indexPathForRow:row inSection:0];
            [self.tableView deleteRowsAtIndexPaths:@[path] withRowAnimation:UITableViewRowAnimationFade];
        }else{
            [self.tableView reloadData];
        }

    }];
    
    QMUIAlertController *alertController = [QMUIAlertController alertControllerWithTitle:@"确定删除？" message:[NSString stringWithFormat:@"确定删除商品\n%@",model.goodsName] preferredStyle:QMUIAlertControllerStyleAlert];
    [alertController addAction:cancel];
    [alertController addAction:delete];
    [alertController showWithAnimated:YES];
}

#pragma --mark delegate

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.dataSource.count;
}
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    ShoppingCartCell *cell = [tableView dequeueReusableCellWithIdentifier:NMUIChainModelIdentifier(ShoppingCartCell.class) forIndexPath:indexPath];
    GoodsModel *model = self.dataSource[indexPath.row];
    cell.model = model;

    @weakify(self);
    cell.selectBlock = ^(BOOL select) {
        @strongify(self);
        [self selectGoods:model isSelect:select];
    };
    cell.goodsCountChangeBlock = ^(NSInteger count) {
        @strongify(self);
        [self changeGoodsCount:model count:count];
    };
    return cell;
}

-(void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    GoodsModel *model  = self.dataSource[indexPath.row];
    [QMUITips showInfo:[NSString stringWithFormat:@"商品信息：%@",model.goodsName] inView:self.view hideAfterDelay:2];
    NSLog(@"%s",__func__);
}
-(NSArray *)tableView:(UITableView *)tableView editActionsForRowAtIndexPath:(NSIndexPath *)indexPath{
    
    GoodsModel *model  = self.dataSource[indexPath.row];
    @weakify(self);
    UITableViewRowAction *deleteRowAction = [UITableViewRowAction rowActionWithStyle:UITableViewRowActionStyleDestructive title:@"删除" handler:^(UITableViewRowAction *action, NSIndexPath *indexPath) {
        @strongify(self);
        [self deleteIndex:model];
        
    }];
    //修改RowAction的颜色
    deleteRowAction.backgroundColor = QMUICMI.redColor;    
    return @[deleteRowAction];
}


#pragma --mark lazy load

- (UITableView *)tableView {
    if (_tableView == nil) {
        
        UITableViewModelCreate()
        .delegate(self)
        .dataSource(self)
        .addToSuperView(self.view)
        .rowHeight(113.0/375.0*SCREEN_WIDTH)
        .registerCellClass(ShoppingCartCell.class, NMUIChainModelIdentifier(ShoppingCartCell.class))
        .makeMasonry(^(MASConstraintMaker * _Nonnull make) {
            make.edges.equalTo(self.view).insets(UIEdgeInsetsMake(0, 0, TabBarHeight+49, 0));
        })
        .assignTo(^(__kindof UIView * _Nonnull view) {
            self->_tableView = view;
        });
    }
    return _tableView;
}
- (NSMutableArray *)selectGoodsSource {
    if (_selectGoodsSource == nil) {
        _selectGoodsSource = [[NSMutableArray alloc] init];
    }
    return _selectGoodsSource;
}
- (NSMutableArray *)dataSource {
    if (_dataSource == nil) {
        _dataSource = [[NSMutableArray alloc] init];
    }
    return _dataSource;
}
- (ShoppingCartCounterView *)shoppingCounterView {
    if (_shoppingCounterView == nil) {
        _shoppingCounterView = [[ShoppingCartCounterView alloc] init];
        [self.view addSubview:_shoppingCounterView];
        @weakify(self);
        _shoppingCounterView.selectAllBlock = ^(BOOL isSelectAll) {
            @strongify(self);
            [self selectAllGood:isSelectAll];
        };
        _shoppingCounterView.orderAction = ^{
            @strongify(self);
            [self orderAction];
        };
        [_shoppingCounterView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self.view);
            make.height.mas_equalTo(49);
            make.bottom.inset(TabBarHeight);
        }];
    }
    return _shoppingCounterView;
}

@end
