//
//  ActivityCollectionCell.m
//  Mall-iOS
//
//  Created by Nemo on 2020/10/13.
//

#import "ActivityCollectionCell.h"
#import <Masonry/Masonry.h>
#import <NMCategories/NMCategories.h>
#import <NMTheme/NMTheme.h>

@interface ActivityCollectionCell()
@property (nonatomic, strong) UIImageView *iconIv;
@property (nonatomic, strong) UILabel *detailTextLb;
@property (nonatomic, strong) UILabel *titleLb;
@end

@implementation ActivityCollectionCell

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)setup {
    
//    self.backgroundColor = RGBCOLOR(247, 247, 247);
    self.backgroundColor = UIColor.nm_backgroundColor;

    [self.contentView addSubview:self.iconIv];
    [self.iconIv mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self);
    }];
    
    [self.contentView addSubview:self.titleLb];
    [self.titleLb mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.top.inset(15);
        make.right.lessThanOrEqualTo(self.mas_right).inset(15);
    }];
    
    [self.contentView addSubview:self.detailTextLb];
    [self.detailTextLb mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.equalTo(self.titleLb);
        make.top.equalTo(self.titleLb.mas_bottom).offset(5);
    }];
    
    
}

- (void)setTitle:(NSString *)title {
    _title = title;
    self.detailTextLb.text = title;
}
- (void)setDetailText:(NSString *)detailText {
    _detailText = detailText;
    self.detailTextLb.text = detailText;
}

- (void)setUrl:(NSString *)url {
    _url = url;
    self.iconIv.image = [UIImage imageNamed:@"group_portrait"];
}

- (UILabel *)detailTextLb {
    if (_detailTextLb == nil) {
        _detailTextLb = [[UILabel alloc] init];
        _detailTextLb.font = FONTSIZE(13);
        _detailTextLb.textColor = RGBCOLOR(102, 102, 102);
        _detailTextLb.text = @"热销爆款不容错过";
    }
    return _detailTextLb;;
}
- (UILabel *)titleLb {
    if (_titleLb == nil) {
        _titleLb = [[UILabel alloc] init];
        _titleLb.font = FONTSIZE(13);
        _titleLb.textColor = RGBCOLOR(33, 33, 33);
        _titleLb.text = @"新品热销榜";
    }
    return _titleLb;;
}

- (UIImageView *)iconIv {
    if (_iconIv == nil) {
        _iconIv = [[UIImageView alloc] init];
        _iconIv.image = [UIImage imageNamed:@"group_portrait"];
    }
    return _iconIv;
}


@end
