//
//  HomeGoodsCell.m
//  Mall-iOS
//
//  Created by Nemo on 2020/10/12.
//

#import "HomeGoodsCell.h"
#import <Masonry/Masonry.h>
#import <NMCategories/NMCategories.h>
#import "AttributLabel.h"
#import "HomeGoodsModel.h"

@interface HomeGoodsCell()
@property (nonatomic, strong) AttributLabel *goodsTextLb;
@property (nonatomic, strong) AttributLabel *goodsPriceLb;
@property (nonatomic, strong) UIImageView *goodsIv;
@end


@implementation HomeGoodsCell

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)setup {
    self.backgroundColor = [UIColor whiteColor];
    
    [self.contentView addSubview:self.goodsIv];
    [self.goodsIv mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.right.left.inset(15);
        make.width.equalTo(self.goodsIv.mas_height).multipliedBy(1);
    }];
    
    [self.contentView addSubview:self.goodsTextLb];
    [self.goodsTextLb mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.goodsIv.mas_bottom).offset(12);
        make.left.right.equalTo(self.goodsIv);
        make.width.equalTo(self.goodsIv.mas_height).multipliedBy(1);
    }];
    
    [self.contentView addSubview:self.goodsPriceLb];
    [self.goodsPriceLb mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.goodsTextLb.mas_bottom).offset(7);
        make.left.equalTo(self.goodsTextLb);
        make.width.lessThanOrEqualTo(self.goodsIv.mas_width);
    }];
}


-(void)setModel:(HomeGoodsModel *)model {
    _model = model;
    if (model.goodsType == HomeGoodsModelTypeNone) {
        _goodsPriceLb.text = [NSString stringWithFormat:@"¥%.f",model.price];
        _goodsTextLb.text = model.goodsTitle;
    }else {
        NSString *text = [NSString stringWithFormat:@"¥%.f ¥%.f",model.price,model.originPrice];
        [_goodsPriceLb setStrikethroughForString:text strikethroughText:[NSString stringWithFormat:@"¥%.f",model.originPrice] strikethroughColor:RGBCOLOR(191, 191, 191)];
        
        [_goodsTextLb setIconForString:model.goodsTitle image:[UIImage imageNamed:@"group_portrait"]];
    }
    

}


- (UIImageView *)goodsIv {
    if (_goodsIv == nil) {
        _goodsIv = [[UIImageView alloc] init];
        _goodsIv.image = [UIImage imageNamed:@"group_portrait"];
    }
    return _goodsIv;
}
- (AttributLabel *)goodsPriceLb {
    if (_goodsPriceLb == nil) {
        _goodsPriceLb = [[AttributLabel alloc] init];
        _goodsPriceLb.font = FONTSIZE(14);
        _goodsPriceLb.textColor = RGBCOLOR(102, 102, 102);
        [_goodsPriceLb setStrikethroughForString:@"¥169 ¥249" strikethroughText:@"¥249" strikethroughColor:RGBCOLOR(191, 191, 191)];

    }
    return _goodsPriceLb;
}

- (AttributLabel *)goodsTextLb {
    if (_goodsTextLb == nil) {
        _goodsTextLb = [[AttributLabel alloc] init];
        _goodsTextLb.font = FONTSIZE(13);
        _goodsTextLb.textColor = RGBCOLOR(102, 102, 102);
        _goodsTextLb.numberOfLines = 2;
        [_goodsTextLb setIconForString:@"  琴岛智能除螨电热毯\n安全定时 智能控温" image:[UIImage imageNamed:@"group_portrait"]];
    }
    return _goodsTextLb;
}

@end

