//
//  ActivityView.m
//  Mall-iOS
//
//  Created by Nemo on 2020/10/12.
//

#import "ActivityView.h"
#import <Masonry/Masonry.h>
#import <NMTheme/NMTheme.h>
#import <NMUIChainKit/NMUIChainKit.h>
#import "ActivityCollectionCell.h"
#import <QMUIKit.h>

@interface ActivityView()<UICollectionViewDelegate,UICollectionViewDataSource>
@property (nonatomic, strong) UICollectionView *collectionView;

@end

@implementation ActivityView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setupUI];
    }
    return self;
}

-(void)setupUI {
    
    self.backgroundColor = [UIColor whiteColor];
    [self.collectionView reloadData];
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return 4;
}


- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    ActivityCollectionCell * cell = [collectionView dequeueReusableCellWithReuseIdentifier:NMUIChainModelIdentifier(ActivityCollectionCell.class) forIndexPath:indexPath];
    
    return cell;
}


-(UICollectionView *)collectionView {
    if (_collectionView == nil) {
        UICollectionViewFlowLayout *layout = [[UICollectionViewFlowLayout alloc]init];
        layout.scrollDirection = UICollectionViewScrollDirectionHorizontal;
        CGFloat width = (SCREEN_WIDTH -15)/2.0;
        // 上下的距离
        layout.minimumLineSpacing = 5;
        layout.minimumInteritemSpacing = 5;
        CGFloat height = 135.0/180.0*width;
        layout.itemSize = CGSizeMake(width, height);
        layout.sectionInset = UIEdgeInsetsMake(0, 5, 0, 0);

        UICollectionViewCreateWithLayout(layout).makeChain
        .addToSuperView(self)
        .delegate(self)
        .dataSource(self)
        .showsHorizontalScrollIndicator(NO)
        .showsHorizontalScrollIndicator(NO)
        .backgroundColor(UIColor.nm_backgroundColor)
        .registerCellClass(ActivityCollectionCell.class, NMUIChainModelIdentifier(ActivityCollectionCell.class))
        .assignTo(^(__kindof UIView * _Nonnull view) {
            self->_collectionView = view;
        })
        .makeMasonry(^(MASConstraintMaker * _Nonnull make) {
            make.edges.equalTo(self);
        });

    }
    return _collectionView;
}
@end
