//
//  HomeClassificationView.m
//  Mall-iOS
//
//  Created by Nemo on 2020/10/12.
//

#import "HomeClassificationView.h"
#import <NMCategories/NMCategories.h>
#import <NMUIChainKit/NMUIChainKit.h>
#import <NMTheme/NMTheme.h>
#import "HomeClassficationCell.h"
#import "HomeClassificationModel.h"

@interface HomeClassificationView()<UICollectionViewDelegate,UICollectionViewDataSource>
@property (nonatomic, strong) UICollectionView *collectionView;
@end

@implementation HomeClassificationView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setupUI];
    }
    return self;
}

-(void)setupUI {
    self.backgroundColor = UIColor.nm_backgroundColor;
}

- (void)setDataSource:(NSArray<HomeClassificationModel *> *)dataSource {
    _dataSource = dataSource;
    [self.collectionView reloadData];
}


#pragma --mark delegate

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return self.dataSource.count;
}


- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    HomeClassficationCell * cell = [collectionView dequeueReusableCellWithReuseIdentifier:NMUIChainModelIdentifier(HomeClassficationCell.class) forIndexPath:indexPath];
    HomeClassificationModel *model = self.dataSource[indexPath.row];
    cell.iconName = model.iconName;
    
    return cell;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath {
    HomeClassificationModel *model = self.dataSource[indexPath.row];
    
    !self.cellClickAction ?: self.cellClickAction(model);
    
    //[QMUITips showSucceed:model.iconName inView:QMUIHelper.visibleViewController.view hideAfterDelay:2];

}

-(UICollectionView *)collectionView {
    if (_collectionView == nil) {
        UICollectionViewFlowLayout *layout = [[UICollectionViewFlowLayout alloc]init];
        layout.scrollDirection = UICollectionViewScrollDirectionHorizontal;
        CGFloat lineSpacing = (NMScreenWidth() -45*5)/6.0;
        // 上下的距离
        layout.minimumLineSpacing = lineSpacing;
        layout.minimumInteritemSpacing = 20;

        //CGFloat height = 255/188*width;
        layout.itemSize = CGSizeMake(45, 72);
        layout.sectionInset = UIEdgeInsetsMake(30, lineSpacing, 30, 0);

        UICollectionViewCreateWithLayout(layout).makeChain
        .dataSource(self)
        .delegate(self)
        .showsVerticalScrollIndicator(NO)
        .showsHorizontalScrollIndicator(NO)
        .backgroundColor(UIColor.nm_backgroundColor)
        .addToSuperView(self)
        .registerCellClass(HomeClassficationCell.class, NMUIChainModelIdentifier(HomeClassficationCell.class))
        .assignTo(^(__kindof UIView * _Nonnull view) {
            self->_collectionView = view;
        })
        .makeMasonry(^(MASConstraintMaker * _Nonnull make) {
            make.edges.equalTo(self);
        });

    }
    return _collectionView;
}

@end

