//
//  HomeViewController.m
//  Mall-iOS
//
//  Created by Nemo on 2020/10/12.
//

#import "HomeViewController.h"
#import <Masonry/Masonry.h>
#import <NMCategories/NMCategories.h>
#import <QMUIKit.h>
#import <NMRouter.h>
#import "HomeGoodsCell.h"
#import "HomeGoodsModel.h"
#import "HomeViewModel.h"
#import "HomeClassificationModel.h"
#import "HomeCollectionHeaderView.h"
#import <NMUIChainKit/NMUIChainKit.h>
//#import <JYSearchModule/JYSearchModule.h>
#import <JYSearchModule.h>


@interface HomeViewController ()<UICollectionViewDelegate,UICollectionViewDataSource>
@property (nonatomic, strong) HomeViewModel *viewModel;

@property (nonatomic, strong) UICollectionView *collectionView;
@property (nonatomic, assign) CGFloat collectionViewHeaderHeight;
@property (nonatomic, strong) NSMutableArray *dataSource;
@end

@implementation HomeViewController


+ (instancetype)homeViewController {
    HomeViewModel *viewModel = [[HomeViewModel alloc] initServices:[[HomeServices alloc] init]];
    return [[self alloc] initWithViewModel:viewModel];
}
- (instancetype)initWithViewModel:(HomeViewModel *)viewModel {
    if (self = [super init]) {
        self.viewModel = viewModel;
    }
    
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUp];
    
    [self bindViewModel];
    
    [self requestNewData];
}

- (void)requestNewData {
    
    if (self.dataSource.count > 0) {
        [self.dataSource removeAllObjects];
    }
    for (int i = 0 ; i < 10; i ++) {
        HomeGoodsModel *model = [[HomeGoodsModel alloc] init];
        model.goodsTitle = @"琴岛智能除螨电热毯\n安全定时 智能控温";
        model.price = 169.0f + i;
        model.originPrice = 249.0 + i;
        model.goodsType = (i%2)?HomeGoodsModelTypeNone:HomeGoodsModelTypeCom;
        [self.dataSource addObject:model];
    }
    
    NSArray *ary = @[@"居家",@"鞋包配饰",@"服装",
                @"电器",@"婴童",@"饮食",
                @"特色区",@"洗护",@"餐厨",@"文体"];
    
    NSMutableArray <HomeClassificationModel *>*list = [[NSMutableArray alloc] initWithCapacity:ary.count];
    
    for (int i = 0; i < ary.count; i ++) {
        HomeClassificationModel *model = [[HomeClassificationModel alloc] init];
        model.iconUrl = @"";
        model.iconName = ary[i];
        [list addObject:model];
    }
    self.viewModel.model.classificaAraay = list;
    
    [self.collectionView reloadData];
    [self.collectionView.mj_header endRefreshing];
    
}

- (void)requestMoreData {

    for (int i = 0 ; i < 10; i ++) {
        HomeGoodsModel *model = [[HomeGoodsModel alloc] init];
        model.goodsTitle = @"琴岛智能除螨电热毯\n安全定时 智能控温";
        model.price = 169.0f + i;
        model.originPrice = 249.0 + i;
        model.goodsType = (i%2)?HomeGoodsModelTypeNone:HomeGoodsModelTypeCom;
        [self.dataSource addObject:model];
    }
    [self.collectionView reloadData];
    [self.collectionView.mj_footer endRefreshing];

}

- (void)setUp {
    
    self.collectionViewHeaderHeight =  926.0/375*SCREEN_WIDTH;
    self.view.backgroundColor = [UIColor whiteColor];

    _dataSource = [[NSMutableArray alloc] init];
    
    @weakify(self);
    [self.collectionView footerWithRefreshingBlock:^{
        @strongify(self);
        [self requestMoreData];
    }];
    [self.collectionView headerWithRefreshingBlock:^{
        @strongify(self);
        [self requestNewData];
    }];
}

- (void)searchAction {
    
    UIViewController *search = [[NMRouter sharedInstance] jyMediatorViewController];
    UINavigationController *nav = [[UINavigationController alloc] initWithRootViewController:search];
    if(@available(iOS 13.0, *)) {
        nav.modalPresentationStyle = UIModalPresentationFullScreen;
    }
    [self presentViewController:nav animated:NO completion:nil];
}

- (void)bindViewModel {
    
    [self.viewModel.homeCommand execute:@"aaaa"];
    
    @weakify(self);
    [[RACObserve(self.viewModel.model, carouselAraay)  skip:1] subscribeNext:^(id  _Nullable x) {
        @strongify(self);
        [self.collectionView reloadData];
    }];

    [[self.viewModel.errSubject distinctUntilChanged] subscribeNext:^(NSError *err) {
        @strongify(self);
        [self.collectionView endRefresh];
        [self showFailToast:[NSString stringWithFormat:@"%@",err.userInfo[NSLocalizedDescriptionKey]]];
    }];
}

#pragma mark - UICollectionViewDelegate

- (UICollectionReusableView *)collectionView:(UICollectionView *)collectionView viewForSupplementaryElementOfKind:(NSString *)kind atIndexPath:(NSIndexPath *)indexPath {
    
    if ([kind isEqualToString:UICollectionElementKindSectionHeader]){
        HomeCollectionHeaderView *header = [HomeCollectionHeaderView dequeueReusableSupplementaryHeaderViewOfKind:collectionView index:indexPath];
        header.headerDict = @{@"Carousels":self.viewModel.model.carouselAraay?:@[],
                              @"Classifica":self.viewModel.model.classificaAraay?:@[]};
        @weakify(self);
        header.searchActionBlcok = ^{
            @strongify(self);
            [self searchAction];
        };
        header.cellAction = ^(HomeClassificationModel * _Nonnull model) {
            @strongify(self);
            [self showWarningToast:model.iconName];
        };
        return header;
    }
    return [UICollectionReusableView new];
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return self.dataSource.count;
}

- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout referenceSizeForHeaderInSection:(NSInteger)section {
    return CGSizeMake(SCREEN_WIDTH, self.collectionViewHeaderHeight);
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    HomeGoodsCell * cell = [collectionView dequeueReusableCellWithReuseIdentifier:NMUIChainModelIdentifier(HomeGoodsCell.class) forIndexPath:indexPath];
    cell.model = self.dataSource[indexPath.row];
    
    return cell;
}

-(UICollectionView *)collectionView {
    if (_collectionView == nil) {
        UICollectionViewFlowLayout *layout = [[UICollectionViewFlowLayout alloc]init];
        layout.scrollDirection = UICollectionViewScrollDirectionVertical;
        layout.minimumLineSpacing = 1;
        layout.minimumInteritemSpacing = 0;
        CGFloat width = (SCREEN_WIDTH -1)/2;
        CGFloat height = 255.0/188.0*width;
        layout.itemSize = CGSizeMake(width, height);
        layout.sectionInset = UIEdgeInsetsMake(0, 0, 0, 0);

        UICollectionViewCreateWithLayout(layout).makeChain
        .addToSuperView(self.view)
        .delegate(self)
        .dataSource(self)
        .showsHorizontalScrollIndicator(NO)
        .showsHorizontalScrollIndicator(NO)
        .backgroundColor(RGBCOLOR(238, 238, 238))
        .registerHeaderViewClass(HomeCollectionHeaderView.class, NMUIChainModelIdentifier(HomeCollectionHeaderView.class))
        .registerCellClass(HomeGoodsCell.class, NMUIChainModelIdentifier(HomeGoodsCell.class))
        .assignTo(^(__kindof UIView * _Nonnull view) {
            self->_collectionView = view;
        })
        .makeMasonry(^(MASConstraintMaker * _Nonnull make) {
            make.edges.equalTo(self.view);
        });
    }
    return _collectionView;
}



@end
