//
//  SearchTagViewCell.m
//  xiangwan
//
//  Created by mac on 2019/8/23.
//  Copyright © 2019 mac. All rights reserved.
//

#import "SearchTagViewCell.h"

@interface SearchTagViewCell()

@property (nonatomic, weak) UIButton *clearBtn;

@end

@implementation SearchTagViewCell


- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier {
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setup];
    }
    return self;
}
- (void)setup {
    UILabel *headerLb = [[UILabel alloc] init];
    headerLb.font = [UIFont systemFontOfSize:16];
    [self.contentView addSubview:headerLb];
    self.headerLb = headerLb;
    [headerLb mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(16);
        make.top.mas_equalTo(24);
        make.height.mas_equalTo(21);
    }];
    
    UIButton *clearBtn = [UIButton buttonWithType:UIButtonTypeSystem];
    [clearBtn setTitle:@"清空" forState:UIControlStateNormal];
    [clearBtn setTitleColor:[UIColor blueColor] forState:UIControlStateNormal];
    clearBtn.titleLabel.font = [UIFont systemFontOfSize:16];
    [clearBtn addTarget:self action:@selector(clearBtnAction) forControlEvents:UIControlEventTouchUpInside];
    [self.contentView addSubview:clearBtn];
    self.clearBtn = clearBtn;
    [clearBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(headerLb);
        make.right.inset(16);
    }];
    
    NMTagView *tagView = [[NMTagView alloc] init];
    [self.contentView addSubview:tagView];
    self.tagView = tagView;
    [tagView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.equalTo(self.contentView);
        make.left.right.inset(16);
        make.top.equalTo(headerLb.mas_bottom).offset(16);
    }];
    
}
-(void)setShowClearBtn:(BOOL)showClearBtn {
    _showClearBtn = showClearBtn;
    self.clearBtn.hidden = !showClearBtn;
}

- (void)clearBtnAction {
    !self.clearAction ?: self.clearAction();
}
- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
