//
//  NMRouter+SearchModuleActions.m
//  Mall-iOS
//
//  Created by Nemo on 2020/10/16.
//

#import "NMRouter+SearchModuleActions.h"

//  1. 字符串 是类名 JYXxx.h 中的 xxx 部分
NSString * const kCTMediatorTargetCourse = @"SearchTargetModule";

//  2. 字符串是 JYxxx.h 中 定义的 jyXxx 函数名的 xxx 部分
NSString * const kCTMediatorActionNativToNativeCourse = @"NativeSearchViewController";

@implementation NMRouter (SearchModuleActions)

- (UIViewController *)jyMediatorViewController {
    UIViewController *viewController = [self performTarget:kCTMediatorTargetCourse
                                                    action:kCTMediatorActionNativToNativeCourse
                                                    params:nil
                                         shouldCacheTarget:NO
                                        ];
    if ([viewController isKindOfClass:[UIViewController class]]) {
        // view controller 交付出去之后，可以由外界选择是push还是present
        return viewController;
    } else {
        // 这里处理异常场景，具体如何处理取决于产品
        NSLog(@"%@ 未能实例化页面", NSStringFromSelector(_cmd));
        return [[UIViewController alloc] init];
    }
}
@end
