//
//  NMTagView.h
//  CQ_App
//
//  Created by mac on 2019/4/9.
//  Copyright © 2019年 mac. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "NMTag.h"

NS_ASSUME_NONNULL_BEGIN

@interface NMTagView : UIView

@property (assign, nonatomic) UIEdgeInsets padding; //内边距
@property (assign, nonatomic) CGFloat lineSpacing;  //行间距
@property (assign, nonatomic) CGFloat interitemSpacing;  //item间距
@property (assign, nonatomic) CGFloat preferredMaxLayoutWidth; //最大宽度
@property (assign, nonatomic) CGFloat regularWidth; //!< 固定宽度
@property (nonatomic,assign ) CGFloat regularHeight; //!< 固定高度
@property (assign, nonatomic) BOOL singleLine;
@property (nonatomic, assign) BOOL isTagBtnEnable; //标签按钮是否可点击 NO:可点击, YES: 不可点击
@property (copy, nonatomic, nullable) void (^didTapTagAtIndex)(NSUInteger index);

- (void)addTag: (nonnull NMTag *)tag;
- (void)insertTag: (nonnull NMTag *)tag atIndex:(NSUInteger)index;
- (void)removeTag: (nonnull NMTag *)tag;
- (void)removeTagAtIndex: (NSUInteger)index;
- (void)removeAllTags;


@end

NS_ASSUME_NONNULL_END
