//
//  SearchTagView.m
//  xiangwan
//
//  Created by mac on 2019/8/23.
//  Copyright © 2019 mac. All rights reserved.
//

#import "SearchTagView.h"
#import "SearchTagViewCell.h"
#import "SearchTagHeaderModel.h"
#import "NMTag.h"
#import <UITableView+FDTemplateLayoutCell.h>

#define nScreenWidth UIScreen.mainScreen.bounds.size.width

@interface SearchTagView()<UITableViewDelegate,UITableViewDataSource>
@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, strong) NSMutableArray *dataSource;
@end

@implementation SearchTagView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)setup {
    [self addSubview:self.tableView];
    [self.tableView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self);
    }];
    
    [self.tableView registerClass:[SearchTagViewCell class] forCellReuseIdentifier:[self identifier]];
}

- (NSString *)identifier {
    return [NSString stringWithFormat:@"%@Id",[SearchTagViewCell class]];
}

-(void)setDatas:(NSArray *)datas {
    _datas = datas;
    self.dataSource = [[NSMutableArray alloc] initWithArray:datas];
    [self.tableView reloadData];
}
- (void)insertSection:(SearchTagHeaderModel *)item {
    [self.dataSource insertObject:item atIndex:0];
    
    NSIndexPath *insert = [NSIndexPath indexPathForRow:0 inSection:0];
    [self.tableView insertRowsAtIndexPaths:@[insert] withRowAnimation:UITableViewRowAnimationNone];
}
- (NSInteger)insertRow:(SearchTagModel *)item {
    
    NSInteger idx = [self checkRepeat:item.tagText];
    
    if (idx == -1) {
        SearchTagHeaderModel *model = self.dataSource.firstObject;
        NSMutableArray *ary = [[NSMutableArray alloc] initWithArray:model.tagModels];
        if (ary.count > 9) {
            [ary removeLastObject];
        }
        [ary insertObject:item atIndex:0];
        model.tagModels = ary;
    }
    NSIndexPath *insert = [NSIndexPath indexPathForRow:0 inSection:0];
    [self.tableView reloadRowsAtIndexPaths:@[insert] withRowAnimation:UITableViewRowAnimationNone];

    return idx;
}
- (NSInteger)checkRepeat:(NSString *)text {
    NSPredicate *predicate = [NSPredicate predicateWithFormat:@"tagText = %@",text];
    SearchTagHeaderModel *model = self.dataSource.firstObject;
    NSArray *result = [model.tagModels filteredArrayUsingPredicate:predicate];
    SearchTagModel *item = result.firstObject;
    NSInteger index = [model.tagModels indexOfObject:item];
    if (index < model.tagModels.count && index != 0) {
        NSMutableArray *ary = [[NSMutableArray alloc] initWithArray:model.tagModels];
        [ary exchangeObjectAtIndex:0 withObjectAtIndex:index];
        model.tagModels = ary;
    }
    
    return (result.count == 0)?-1:index;
}

- (void)clearRecord {
    [self.dataSource removeObjectAtIndex:0];
    NSIndexPath *insert = [NSIndexPath indexPathForRow:0 inSection:0];
    [self.tableView deleteRowsAtIndexPaths:@[insert] withRowAnimation:UITableViewRowAnimationNone];
    !self.clearAll ?: self.clearAll();
}

-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.dataSource.count;
}
-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    SearchTagViewCell *cell = [tableView dequeueReusableCellWithIdentifier:[self identifier]];
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    cell.showClearBtn = (indexPath.row == 0 && self.dataSource.count > 1);
    [self configCell:cell indexPath:indexPath];
    @weakify(self);
    cell.clearAction = ^{
        @strongify(self);
        [self clearRecord];
    };
    return cell;
}

- (void)configCell:(SearchTagViewCell *)cell indexPath:(NSIndexPath *)indexPath
{
    [cell.tagView removeAllTags];
    cell.tagView.preferredMaxLayoutWidth = nScreenWidth-32;
    //cell.tagView.padding = UIEdgeInsetsMake(0, 0, 0, 0);
    cell.tagView.lineSpacing = 10;
    cell.tagView.interitemSpacing = 10;
    cell.tagView.singleLine = NO;
    // 给出两个字段，如果给的是0，那么就是变化的,如果给的不是0，那么就是固定的
    //        cell.tagView.regularWidth = 80;
    //        cell.tagView.regularHeight = 30;
    SearchTagHeaderModel *model = self.dataSource[indexPath.row];
    cell.headerLb.text = model.headerText;
    NSArray *arr = model.tagModels;
    @weakify(self);
    [arr enumerateObjectsUsingBlock:^(id  _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        @strongify(self);
        SearchTagModel *subModel = arr[idx];
        NMTag *tag = [self createTag:subModel.tagText];
        [cell.tagView addTag:tag];
    }];
    
    cell.tagView.didTapTagAtIndex = ^(NSUInteger index) {
        @strongify(self);
        SearchTagModel *subModel = arr[index];
        [self cellAction:subModel];
    };
}
- (void)cellAction:(SearchTagModel *)model {
    if (self.tagClick) {
        self.tagClick(model.tagText);
    }
}
- (NMTag *)createTag:(NSString *)text {
    NMTag *tag = [[NMTag alloc] initWithText:text];
    tag.font = [UIFont systemFontOfSize:14];
    tag.textColor = [UIColor colorWithRed:34.0/255 green:34.0/255 blue:34.0/255 alpha:1];
    tag.bgColor = [UIColor colorWithRed:249.0/255 green:249.0/255 blue:249.0/255 alpha:1];
    tag.cornerRadius = 8;
    tag.enable = YES;
    tag.padding = UIEdgeInsetsMake(6, 16, 6, 16);
    return tag;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    @weakify(self);
    return [tableView fd_heightForCellWithIdentifier:[self identifier] configuration:^(id cell) {
        @strongify(self);
        [self configCell:cell indexPath:indexPath];
    }];
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
}

-(UITableView *)tableView {
    if (_tableView == nil) {
        _tableView = [[UITableView alloc] init];
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.tableFooterView = [UIView new];
        _tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        
    }
    return _tableView;
}

-(NSMutableArray *)dataSource {
    if (_dataSource == nil) {
        _dataSource = [[NSMutableArray alloc] init];
    }
    return _dataSource;
}
@end
