//
//  JYSearchViewController.m
//  Mall-iOS
//
//  Created by Nemo on 2020/10/16.
//

#import "JYSearchViewController.h"
#import "SearchTagView.h"
#import "SKSearchBar.h"
#import <QMUIKit.h>

@interface JYSearchViewController ()
@property (nonatomic, weak) SKSearchBar *search;
@property (nonatomic, weak) SearchTagView *tagView;

@property (nonatomic, weak) UIButton *searchBtn;

@property (nonatomic, strong) NSMutableArray *historys;
@property (nonatomic, strong) NSMutableArray *searchDataSource;
@property (nonatomic, assign) NSInteger index;
@end

@implementation JYSearchViewController

+ (instancetype)jySearchViewController {
    //HomeViewModel *viewModel = [[HomeViewModel alloc] initServices:[[HomeServices alloc] init]];
    return [[self alloc] init];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.view.backgroundColor = [UIColor redColor];
    
}

- (void)createTagView {
    SearchTagView *tagView = [[SearchTagView alloc] init];
    [self.view addSubview:tagView];
    self.tagView = tagView;
    @weakify(self);
    tagView.tagClick = ^(NSString * _Nonnull text) {
        @strongify(self);
        self.search.text = text;
        //[self searchAction];
    };
    
    tagView.clearAll = ^{
        @strongify(self);

        [self.historys removeAllObjects];
        [self.searchDataSource removeObjectAtIndex:0];
        //[[DatabaseCenter sharedDatabaseCenter].historyDBMager deleteAllConditions:nil];
    };
    /**
     
    [tagView addGestureRecognizer:[[UITapGestureRecognizer alloc] initWithActionBlock:^(id  _Nonnull sender) {
        @strongify(self);

        [self.search resignFirstResponder];
    }]];
     */
    
    [tagView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.mas_equalTo(0);
        make.bottom.inset(291);
    }];
}
- (void)initData {
    
    self.historys = [[NSMutableArray alloc] initWithArray:@[]];
    NSArray *hotWords = @[];
    if (hotWords.count == 0) {
        hotWords = @[@{@"text":@"吃饭"},@{@"text":@"喝东西"},@{@"text":@"唱歌"}];
    }
    self.searchDataSource = [[NSMutableArray alloc] init];
    if (self.historys.count > 0) {
        [self.searchDataSource addObject:@{@"data":self.historys,@"title":@"历史记录"}];
    }
    [self.searchDataSource addObject:@{@"data":hotWords,@"title":@"热搜"}];
    NSMutableArray *arry = [[NSMutableArray alloc] init];
    for (int i = 0; i < self.searchDataSource.count; i ++) {
        NSDictionary *dict = self.searchDataSource[i];
        SearchTagHeaderModel *model = [[SearchTagHeaderModel alloc] init];
        model.headerText = dict[@"title"];
        NSMutableArray *ary = [[NSMutableArray alloc] init];
        NSArray *datas = dict[@"data"];
        for (int j = 0; j < datas.count; j ++) {
            NSDictionary *dt = datas[j];
            SearchTagModel *subMdl = [[SearchTagModel alloc] init];
            subMdl.tagText = dt[@"text"];
            [ary addObject:subMdl];
        }
        model.tagModels = ary;
        [arry addObject:model];
    }
    self.tagView.datas = arry;
}

@end
