//
//  AppDelegate.m
//  Mall-iOS
//
//  Created by Nemo on 2020/10/12.
//

#import "AppDelegate.h"
#import "HomeViewController.h"
#import "ShoppingCartViewController.h"
#import "MacroDefinition.h"

@interface AppDelegate ()


@end

@implementation AppDelegate


- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {


    UITabBarController *tab = [[UITabBarController alloc] init];

    HomeViewController *home = [[HomeViewController alloc] init];
    home.title = @"主页";
    home.tabBarItem = [[UITabBarItem alloc] initWithTitle:@"主页"
                                                   image:[UIImage imageNamed:@"index"]
                                           selectedImage:[UIImage imageNamed:@"index_s"]];
    UINavigationController* homeNav = [[UINavigationController alloc] initWithRootViewController:home];
    
    ShoppingCartViewController *shopping = [[ShoppingCartViewController alloc] init];
    shopping.title = @"购物车";
    shopping.tabBarItem = [[UITabBarItem alloc] initWithTitle:@"购物车"
                                                   image:[UIImage imageNamed:@"shoppingCart"]
                                           selectedImage:[UIImage imageNamed:@"shoppingCart_s"]];

    [[UITabBar appearance] setTintColor:[UIColor colorWithRed:163.0f/255.0f green:46.0f/255.0f blue:46.0f/255.0f alpha:1.0f]];
    
    UINavigationController* shoppingNav = [[UINavigationController alloc] initWithRootViewController:shopping];
    tab.viewControllers = @[homeNav,shoppingNav];
    tab.selectedIndex = 1;
    self.window.rootViewController = tab;
    [self.window makeKeyAndVisible];
    
    return YES;
}


#pragma mark - UISceneSession lifecycle

/**
 - (UISceneConfiguration *)application:(UIApplication *)application configurationForConnectingSceneSession:(UISceneSession *)connectingSceneSession options:(UISceneConnectionOptions *)options {
     // Called when a new scene session is being created.
     // Use this method to select a configuration to create the new scene with.
     return [[UISceneConfiguration alloc] initWithName:@"Default Configuration" sessionRole:connectingSceneSession.role];
 }
 
 - (void)application:(UIApplication *)application didDiscardSceneSessions:(NSSet<UISceneSession *> *)sceneSessions {
     // Called when the user discards a scene session.
     // If any sessions were discarded while the application was not running, this will be called shortly after application:didFinishLaunchingWithOptions.
     // Use this method to release any resources that were specific to the discarded scenes, as they will not return.
 }
 */






@end
