//
//  SceneDelegate.m
//  Mall-iOS
//
//  Created by Nemo on 2020/10/12.
//

#import "SceneDelegate.h"
#import "HomeViewController.h"
#import "ShoppingCartViewController.h"
#import "MacroDefinition.h"


@interface SceneDelegate ()

@end

@implementation SceneDelegate


- (void)scene:(UIScene *)scene willConnectToSession:(UISceneSession *)session options:(UISceneConnectionOptions *)connectionOptions {
    
    UIWindowScene *windowScene = (UIWindowScene *)scene;
    self.window = [[UIWindow alloc] initWithWindowScene:windowScene];
    self.window.frame = windowScene.coordinateSpace.bounds;
    UITabBarController *tab = [[UITabBarController alloc] init];

    HomeViewController *home = [[HomeViewController alloc] init];
    home.title = @"主页";
    home.tabBarItem = [[UITabBarItem alloc] initWithTitle:@"主页"
                                                   image:[UIImage imageNamed:@"index"]
                                           selectedImage:[UIImage imageNamed:@"index_s"]];
    UINavigationController* homeNav = [[UINavigationController alloc] initWithRootViewController:home];
    
    ShoppingCartViewController *shopping = [[ShoppingCartViewController alloc] init];
    shopping.title = @"购物车";
    shopping.tabBarItem = [[UITabBarItem alloc] initWithTitle:@"购物车"
                                                   image:[UIImage imageNamed:@"shoppingCart"]
                                           selectedImage:[UIImage imageNamed:@"shoppingCart_s"]];

    [[UITabBar appearance] setTintColor:[UIColor colorWithRed:163.0f/255.0f green:46.0f/255.0f blue:46.0f/255.0f alpha:1.0f]];
    
    UINavigationController* shoppingNav = [[UINavigationController alloc] initWithRootViewController:shopping];
    tab.viewControllers = @[homeNav,shoppingNav];

    /**
     [[UINavigationBar appearance] setBarTintColor:[UIColor colorWithRed:163.0f/255.0f green:46.0f/255.0f blue:46.0f/255.0f alpha:1.0f]];
     if (@available(iOS 11.0, *)){
         [UITableView appearance].contentInsetAdjustmentBehavior= UIScrollViewContentInsetAdjustmentNever;
         [UITableView appearance].estimatedRowHeight = 0;
         [UITableView appearance].estimatedSectionHeaderHeight = 0;
         [UITableView appearance].estimatedSectionFooterHeight = 0;
     }else {
         self.window.rootViewController.automaticallyAdjustsScrollViewInsets = NO;
     }
     [[UINavigationBar appearance]  setBackgroundImage:[[UIImage alloc] init] forBarPosition:UIBarPositionAny barMetrics:UIBarMetricsDefault];
     [[UINavigationBar appearance] setShadowImage:[[UIImage alloc] init]];
     [[UIButton appearance] setExclusiveTouch:YES];

     */
    
    self.window.rootViewController = tab;
    [self.window makeKeyAndVisible];
}


- (void)sceneDidDisconnect:(UIScene *)scene {
    // Called as the scene is being released by the system.
    // This occurs shortly after the scene enters the background, or when its session is discarded.
    // Release any resources associated with this scene that can be re-created the next time the scene connects.
    // The scene may re-connect later, as its session was not necessarily discarded (see `application:didDiscardSceneSessions` instead).
}


- (void)sceneDidBecomeActive:(UIScene *)scene {
    // Called when the scene has moved from an inactive state to an active state.
    // Use this method to restart any tasks that were paused (or not yet started) when the scene was inactive.
}


- (void)sceneWillResignActive:(UIScene *)scene {
    // Called when the scene will move from an active state to an inactive state.
    // This may occur due to temporary interruptions (ex. an incoming phone call).
}


- (void)sceneWillEnterForeground:(UIScene *)scene {
    // Called as the scene transitions from the background to the foreground.
    // Use this method to undo the changes made on entering the background.
}


- (void)sceneDidEnterBackground:(UIScene *)scene {
    // Called as the scene transitions from the foreground to the background.
    // Use this method to save data, release shared resources, and store enough scene-specific state information
    // to restore the scene back to its current state.
}


@end
