//
//  HomeClassficationCell.m
//  Mall-iOS
//
//  Created by Nemo on 2020/10/12.
//

#import "HomeClassficationCell.h"
#import "MacroDefinition.h"
#import <Masonry.h>

@interface HomeClassficationCell()
@property (nonatomic, strong) UIImageView *iconIv;
@property (nonatomic, strong) UILabel *nameLb;
@end

@implementation HomeClassficationCell

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)setup {
    self.backgroundColor = [UIColor whiteColor];
    
    [self.contentView addSubview:self.iconIv];
    [self.iconIv mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.height.mas_equalTo(45);
        make.top.left.equalTo(self);
    }];
    
    [self.contentView addSubview:self.nameLb];
    [self.nameLb mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.centerX.equalTo(self);
    }];
}

- (void)setIconName:(NSString *)iconName {
    _iconName = iconName;
    self.nameLb.text = iconName;
}

- (void)setIconUrl:(NSString *)iconUrl {
    _iconUrl = iconUrl;
    self.iconIv.image = [UIImage imageNamed:@"group_portrait"];
}

- (UILabel *)nameLb {
    if (_nameLb == nil) {
        _nameLb = [[UILabel alloc] init];
        _nameLb.font = FONTSIZE(13);
        _nameLb.textColor = RGBCOLOR(102, 102, 102);
    }
    return _nameLb;;
}
- (UIImageView *)iconIv {
    if (_iconIv == nil) {
        _iconIv = [[UIImageView alloc] init];
        _iconIv.image = [UIImage imageNamed:@"group_portrait"];
    }
    return _iconIv;
}


@end
