//
//  ActivityView.m
//  Mall-iOS
//
//  Created by Nemo on 2020/10/12.
//

#import "ActivityView.h"
#import "UICollectionViewCell+Extension.h"
#import "ActivityCollectionCell.h"
#import <Masonry.h>
#import <QMUIKit.h>

@interface ActivityView()<UICollectionViewDelegate,UICollectionViewDataSource>
@property (nonatomic, strong) UICollectionView *collectionView;

@end

@implementation ActivityView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setupUI];
    }
    return self;
}

-(void)setupUI {
    
    self.backgroundColor = [UIColor whiteColor];
    [self.collectionView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self);
    }];
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return 4;
}


- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    ActivityCollectionCell * cell = [collectionView dequeueReusableCellWithReuseIdentifier:[ActivityCollectionCell identifier] forIndexPath:indexPath];
    
    return cell;
}


-(UICollectionView *)collectionView {
    if (_collectionView == nil) {
        UICollectionViewFlowLayout *layout = [[UICollectionViewFlowLayout alloc]init];
        layout.scrollDirection = UICollectionViewScrollDirectionHorizontal;
        CGFloat width = (SCREEN_WIDTH -15)/2.0;
        // 上下的距离
        layout.minimumLineSpacing = 5;
        layout.minimumInteritemSpacing = 5;
        CGFloat height = 135.0/180.0*width;
        layout.itemSize = CGSizeMake(width, height);
        layout.sectionInset = UIEdgeInsetsMake(0, 5, 0, 0);

        _collectionView = [[UICollectionView alloc]initWithFrame:CGRectZero collectionViewLayout:layout];
        _collectionView.delegate = self;
        _collectionView.dataSource = self;
        _collectionView.showsHorizontalScrollIndicator = NO;
        _collectionView.showsVerticalScrollIndicator = NO;
        _collectionView.backgroundColor = [UIColor whiteColor];
        [self addSubview:_collectionView];
        
        [ActivityCollectionCell registerClassForCollectionView:_collectionView];

    }
    return _collectionView;
}
@end
