//
//  HomeClassificationView.m
//  Mall-iOS
//
//  Created by Nemo on 2020/10/12.
//

#import "HomeClassificationView.h"
#import <QMUIKit.h>
#import "HomeClassficationCell.h"
#import "UICollectionViewCell+Extension.h"
#import <Masonry.h>

@interface HomeClassificationView()<UICollectionViewDelegate,UICollectionViewDataSource>
@property (nonatomic, strong) UICollectionView *collectionView;
@end

@implementation HomeClassificationView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setupUI];
    }
    return self;
}

-(void)setupUI {
    self.backgroundColor = [UIColor whiteColor];
    [self.collectionView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self);
    }];
}

- (void)setDataSource:(NSArray<HomeClassificationModel *> *)dataSource {
    _dataSource = dataSource;
    
    [self.collectionView reloadData];
}


#pragma --mark delegate

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return self.dataSource.count;
}


- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    HomeClassficationCell * cell = [collectionView dequeueReusableCellWithReuseIdentifier:[HomeClassficationCell identifier] forIndexPath:indexPath];
    HomeClassificationModel *model = self.dataSource[indexPath.row];
    cell.iconName = model.iconName;
    
    return cell;
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath {
    HomeClassificationModel *model = self.dataSource[indexPath.row];
    
    [QMUITips showSucceed:model.iconName inView:QMUIHelper.visibleViewController.view hideAfterDelay:2];

}

-(UICollectionView *)collectionView {
    if (_collectionView == nil) {
        UICollectionViewFlowLayout *layout = [[UICollectionViewFlowLayout alloc]init];
        layout.scrollDirection = UICollectionViewScrollDirectionHorizontal;
        CGFloat lineSpacing = (SCREEN_WIDTH -45*5)/6.0;
        // 上下的距离
        layout.minimumLineSpacing = lineSpacing;
        layout.minimumInteritemSpacing = 20;

        //CGFloat height = 255/188*width;
        layout.itemSize = CGSizeMake(45, 72);
        layout.sectionInset = UIEdgeInsetsMake(30, lineSpacing, 30, 0);

        _collectionView = [[UICollectionView alloc]initWithFrame:CGRectZero collectionViewLayout:layout];
        _collectionView.delegate = self;
        _collectionView.dataSource = self;
        _collectionView.decelerationRate = 0.8;
        _collectionView.showsHorizontalScrollIndicator = NO;
        _collectionView.showsVerticalScrollIndicator = NO;
        _collectionView.backgroundColor = [UIColor whiteColor];
        [self addSubview:_collectionView];
        
        [HomeClassficationCell registerClassForCollectionView:_collectionView];

    }
    return _collectionView;
}

@end


@implementation HomeClassificationModel

@end
