//
//  HomeCollectionHeaderView.m
//  Mall-iOS
//
//  Created by Nemo on 2020/10/12.
//

#import "HomeCollectionHeaderView.h"
#import <Masonry.h>
#import "MacroDefinition.h"
#import <SDCycleScrollView.h>
#import "UIImage+Extension.h"
#import "HomeClassificationView.h"
#import "ActivityView.h"
#import <SDWebImage.h>
#import <QMUIKit.h>

@interface HomeCollectionHeaderView()<SDCycleScrollViewDelegate>
@property (nonatomic, strong) UIButton *searchBtn;
@property (nonatomic, strong) SDCycleScrollView *cycleView;
@property (nonatomic, strong) HomeClassificationView *homeClassficationView;
@property (nonatomic, strong) UIImageView *recommendIv;
@property (nonatomic, strong) ActivityView *activityView;
@end

@implementation HomeCollectionHeaderView


- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setup];
    }
    return self;
}

- (void)setup {
    
    self.backgroundColor = [UIColor whiteColor];
    
    [self addSubview:self.searchBtn];
    [_searchBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.equalTo(self).inset(12);
        make.top.mas_offset(8);
        make.height.mas_equalTo(27);
    }];
    
    NSURL *url = [NSURL URLWithString:@"https://ss0.bdstatic.com/70cFuHSh_Q1YnxGkpoWK1HF6hhy/it/u=3584899235,2312422629&fm=26&gp=0.jpg"];
    self.cycleView.imageURLStringsGroup = @[url,url,url];
    
    
    
    self.homeClassficationView.dataSource = @[];
    
    [self.recommendIv sd_setImageWithURL:[NSURL URLWithString:@"https://ss0.bdstatic.com/70cFuHSh_Q1YnxGkpoWK1HF6hhy/it/u=3584899235,2312422629&fm=26&gp=0.jpg"]];
    
    
    self.activityView.dataSource = @[];

    UILabel *titleLb = [[UILabel alloc] init];
    titleLb.font = FONTBOLDSIZE(15);
    titleLb.text = @"每日精选";
    [self addSubview:titleLb];
    [titleLb mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.inset(19);
        make.bottom.inset(13);
    }];
    
    CALayer *splitLine = [CALayer layer];
    splitLine.frame = CGRectMake(0, self.bounds.size.height-45, self.bounds.size.width, 5);
    splitLine.backgroundColor = RGBCOLOR(242, 245, 247).CGColor;
    [self.layer addSublayer:splitLine];
    
    CALayer *bottomLine = [CALayer layer];
    bottomLine.backgroundColor = RGBCOLOR(242, 245, 247).CGColor;
    bottomLine.frame = CGRectMake(0, self.bounds.size.height-1, self.bounds.size.width, 1);
    [self.layer addSublayer:bottomLine];
    
}

- (void)setHeaderDict:(NSDictionary *)headerDict {
    _headerDict = headerDict;
    NSArray *ary = @[@"居家",@"鞋包配饰",@"服装",
                     @"电器",@"婴童",@"饮食",
                     @"特色区",@"洗护",@"餐厨",@"文体"];
    @autoreleasepool {
        NSMutableArray <HomeClassificationModel *>*list = [[NSMutableArray alloc] init];
        for (int i = 0; i < ary.count; i ++) {
            HomeClassificationModel *model = [[HomeClassificationModel alloc] init];
            model.iconUrl = @"";
            model.iconName = ary[i];
            [list addObject:model];
        }
        self.homeClassficationView.dataSource = list;
    }
    
}

-(void)searchAction {
    NSLog(@"======test");
    [QMUITips showSucceed:@"搜索被点击！" inView:kAppWindow() hideAfterDelay:2];

}

- (UIImageView *)recommendIv {
    if (_recommendIv == nil) {
        _recommendIv = [[UIImageView alloc] init];
        [self addSubview:_recommendIv];
        CGFloat height = 100.0/360.0*SCREEN_WIDTH;
        [_recommendIv mas_makeConstraints:^(MASConstraintMaker *make) {
            make.height.mas_equalTo(height);
            make.top.equalTo(self.homeClassficationView.mas_bottom);
            make.right.left.equalTo(self).inset(8);
        }];
    }
    return _recommendIv;
}
- (ActivityView *)activityView {
    if (_activityView == nil) {
        _activityView = [[ActivityView alloc] init];
        [self addSubview:_activityView];
        CGFloat width = (SCREEN_WIDTH-15)/2.0;

        CGFloat height = 135.0/180.0*width;
        [_activityView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.height.mas_equalTo(height*2+5);
            make.top.equalTo(self.recommendIv.mas_bottom).inset(27);
            make.right.left.equalTo(self);
        }];
    }
    return _activityView;
}
-(HomeClassificationView *)homeClassficationView {
    if (_homeClassficationView == nil) {
        _homeClassficationView = [[HomeClassificationView alloc] init];
        [self addSubview:_homeClassficationView];
        CGFloat height = 231.0/375.0*SCREEN_WIDTH;
        [_homeClassficationView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.height.mas_equalTo(height);
            make.top.equalTo(self.cycleView.mas_bottom);
            make.right.left.equalTo(self.cycleView);
        }];
    }
    return _homeClassficationView;
}
- (SDCycleScrollView *)cycleView {
    if (_cycleView == nil) {
        CGFloat height = 170.0/SCREEN_WIDTH*375.0;
        _cycleView = [SDCycleScrollView cycleScrollViewWithFrame:CGRectMake(0, 43, SCREEN_WIDTH, height) delegate:self placeholderImage:[UIImage imageWithColor:[UIColor grayColor]]];
        _cycleView.backgroundColor = [UIColor whiteColor];
        [self addSubview:_cycleView];
    }
    return _cycleView;
}

-(UIButton *)searchBtn {
    if (_searchBtn == nil) {
        _searchBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [_searchBtn setImage:[UIImage imageNamed:@"search"] forState:UIControlStateNormal];
        [_searchBtn setImage:[UIImage imageNamed:@"search"] forState:UIControlStateHighlighted];
        [_searchBtn setBackgroundColor:RGBCOLOR(243, 243, 243)];
        _searchBtn.titleLabel.font = FONTSIZE(12);
        [_searchBtn setTitle:@" 搜索商品，发现好物" forState:UIControlStateNormal];
        [_searchBtn setTitle:@" 搜索商品，发现好物" forState:UIControlStateHighlighted];
        [_searchBtn setTitleColor:RGBCOLOR(191, 191, 191) forState:UIControlStateNormal];
        [_searchBtn addTarget:self action:@selector(searchAction) forControlEvents:UIControlEventTouchUpInside];
        _searchBtn.layer.cornerRadius = 13;
        _searchBtn.layer.masksToBounds = YES;
        
    }
    return _searchBtn;;
}
@end
