//
//  HomeViewController.m
//  Mall-iOS
//
//  Created by Nemo on 2020/10/12.
//

#import "HomeViewController.h"
#import <Masonry.h>
#import <QMUIKit.h>
#import <MJRefresh.h>
#import "HomeCollectionHeaderView.h"
#import "UICollectionViewCell+Extension.h"
#import "UICollectionReusableView+Extension.h"
#import "HomeGoodsCell.h"
#import "MacroDefinition.h"
#import "HomeGoodsModel.h"

@interface HomeViewController ()<UICollectionViewDelegate,UICollectionViewDataSource>
@property (nonatomic, strong) UICollectionView *collectionView;
@property (nonatomic, assign) CGFloat collectionViewHeaderHeight;
@property (nonatomic, strong) NSMutableArray *dataSource;
@end

@implementation HomeViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setUp];
    
    [self requestNewData];
}

- (void)requestNewData {
    
    if (self.dataSource.count > 0) {
        [self.dataSource removeAllObjects];
    }
    for (int i = 0 ; i < 10; i ++) {
        HomeGoodsModel *model = [[HomeGoodsModel alloc] init];
        model.goodsTitle = @"琴岛智能除螨电热毯\n安全定时 智能控温";
        model.price = 169.0f + i;
        model.originPrice = 249.0 + i;
        model.goodsType = (i%2)?HomeGoodsModelTypeNone:HomeGoodsModelTypeCom;
        [self.dataSource addObject:model];
    }
    [self.collectionView reloadData];
    [self.collectionView.mj_header endRefreshing];
}

- (void)requestMoreData {

    for (int i = 0 ; i < 10; i ++) {
        HomeGoodsModel *model = [[HomeGoodsModel alloc] init];
        model.goodsTitle = @"琴岛智能除螨电热毯\n安全定时 智能控温";
        model.price = 169.0f + i;
        model.originPrice = 249.0 + i;
        model.goodsType = (i%2)?HomeGoodsModelTypeNone:HomeGoodsModelTypeCom;
        [self.dataSource addObject:model];
    }
    [self.collectionView reloadData];
    [self.collectionView.mj_footer endRefreshing];

}

- (void)setUp {
    
    self.collectionViewHeaderHeight =  926.0/375*SCREEN_WIDTH;
    self.view.backgroundColor = [UIColor whiteColor];

    [self.view addSubview:self.collectionView];
    [self.collectionView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self.view);
    }];

    _dataSource = [[NSMutableArray alloc] init];
    
    WeakSelf
    MJRefreshBackNormalFooter *footer = [MJRefreshBackNormalFooter footerWithRefreshingBlock:^{
        [weakSelf requestMoreData];
    }];
    footer.automaticallyChangeAlpha = YES;
    self.collectionView.mj_footer = footer;
    self.collectionView.mj_header = [MJRefreshStateHeader headerWithRefreshingBlock:^{
        [weakSelf requestNewData];
    }];
}

- (void)searchAction {
    
}

#pragma mark - UICollectionViewDelegate

- (UICollectionReusableView *)collectionView:(UICollectionView *)collectionView viewForSupplementaryElementOfKind:(NSString *)kind atIndexPath:(NSIndexPath *)indexPath {
    
    if ([kind isEqualToString:UICollectionElementKindSectionHeader]){
        HomeCollectionHeaderView *header = [HomeCollectionHeaderView dequeueReusableSupplementaryHeaderViewOfKind:collectionView index:indexPath];
        header.headerDict = @{};
        return header;
    }
    return [UICollectionReusableView new];
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section {
    return self.dataSource.count;
}

- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout *)collectionViewLayout referenceSizeForHeaderInSection:(NSInteger)section {
    return CGSizeMake(SCREEN_WIDTH, self.collectionViewHeaderHeight);
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath {
    HomeGoodsCell * cell = [collectionView dequeueReusableCellWithReuseIdentifier:[HomeGoodsCell identifier] forIndexPath:indexPath];
    cell.model = self.dataSource[indexPath.row];
    
    return cell;
}

-(UICollectionView *)collectionView {
    if (_collectionView == nil) {
        UICollectionViewFlowLayout *layout = [[UICollectionViewFlowLayout alloc]init];
        layout.scrollDirection = UICollectionViewScrollDirectionVertical;
        layout.minimumLineSpacing = 1;
        layout.minimumInteritemSpacing = 0;
        CGFloat width = (SCREEN_WIDTH -1)/2;
        CGFloat height = 255.0/188.0*width;
        layout.itemSize = CGSizeMake(width, height);
        layout.sectionInset = UIEdgeInsetsMake(0, 0, 0, 0);

        _collectionView = [[UICollectionView alloc]initWithFrame:CGRectZero collectionViewLayout:layout];
        _collectionView.delegate = self;
        _collectionView.dataSource = self;
        _collectionView.decelerationRate = 0.8;
        _collectionView.showsHorizontalScrollIndicator = NO;
        _collectionView.showsVerticalScrollIndicator = NO;
        _collectionView.backgroundColor = RGBCOLOR(238, 238, 238);
        [self.view addSubview:_collectionView];
        
        [HomeGoodsCell registerClassForCollectionView:_collectionView];

        [HomeCollectionHeaderView registerClassHeaderForCollectionView:_collectionView];
    }
    return _collectionView;
}



@end
