//
//  UICollectionReusableView+Extension.m
//  xiangwan
//
//  Created by mac on 2019/8/27.
//  Copyright © 2019 mac. All rights reserved.
//

#import "UICollectionReusableView+Extension.h"

@implementation UICollectionReusableView (Extension)
+ (void)registerClassFooterForCollectionView:(UICollectionView *)collectionView {
    [collectionView registerClass:self forSupplementaryViewOfKind:UICollectionElementKindSectionFooter withReuseIdentifier:[self identifier]];
}
+ (void)registerNibFooterForCollectionView:(UICollectionView *)collectionView {
    [collectionView registerNib:[UINib nibWithNibName:[self className]
                                               bundle:[NSBundle mainBundle]] forSupplementaryViewOfKind:UICollectionElementKindSectionFooter withReuseIdentifier:[self identifier]];
}
+ (void)registerNibHeaderForCollectionView:(UICollectionView *)collectionView {
    [collectionView registerNib:[UINib nibWithNibName:[self className]
                                               bundle:[NSBundle mainBundle]] forSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:[self identifier]];
}
+ (void)registerClassHeaderForCollectionView:(UICollectionView *)collectionView {
    [collectionView registerClass:self forSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:[self identifier]];
}
+ (instancetype)dequeueReusableSupplementaryHeaderViewOfKind:(UICollectionView *)collectionView index:(NSIndexPath *)indexPath{
    return [collectionView dequeueReusableSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:[self identifier] forIndexPath:indexPath];
}
+ (instancetype)dequeueReusableSupplementaryFooterViewOfKind:(UICollectionView *)collectionView index:(NSIndexPath *)indexPath {
    return [collectionView dequeueReusableSupplementaryViewOfKind:UICollectionElementKindSectionFooter withReuseIdentifier:[self identifier] forIndexPath:indexPath];
}
+ (NSString *)identifier {
    return [NSString stringWithFormat:@"%@Id",[self className]];
}

+ (NSString *)className {
    return NSStringFromClass(self);
}
@end
