//
//  UITableViewHeaderFooterView+Extension.m
//  xiangwan
//
//  Created by mac on 2019/10/8.
//  Copyright © 2019 mac. All rights reserved.
//

#import "UITableViewHeaderFooterView+Extension.h"

@implementation UITableViewHeaderFooterView (Extension)

+ (void)registerClassHeaderFooterForTableView:(UITableView *)tableView {
    [tableView registerClass:self forHeaderFooterViewReuseIdentifier:[self identifier]];
}
+ (void)registerNibHeaderFooterForTableView:(UITableView *)tableView {
    [tableView registerNib:[UINib nibWithNibName:[self className]
                                          bundle:[NSBundle mainBundle]] forHeaderFooterViewReuseIdentifier:[self identifier]];
}
+ (NSString *)identifier {
    return [NSString stringWithFormat:@"%@Id",[self className]];
}

+ (NSString *)className {
    return NSStringFromClass(self);
}
@end
