//
//  UIImage+Extension.h
//  xiangwan
//
//  Created by mac on 2019/8/5.
//  Copyright © 2019 mac. All rights reserved.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@interface UIImage (Extension)

+ (UIImage *)imageWithColor:(UIColor *)color;

// 生成二维码
+ (UIImage *)generateQRCode:(NSString *)code size:(CGSize)size;

//生成一个圆角图片
- (UIImage *)circleImage;

///毛玻璃
- (UIImage *)blurryImage:(UIImage *)image withBlurLevel:(CGFloat)blur;

///根据颜色和圆的半径来创建一个圆形图片
+ (UIImage *)createImageWithColor:(UIColor *)color radius:(CGFloat)radius;

///根据一个view来创建一个 Image
+ (UIImage*)creatImageWithView:(UIView *)theView;

/**
 图片组 本地
 
 @param array 原生image arr
 @param bgColor 新生成image 背景色
 @return image 组合
 */
+ (UIImage *)groupIconWith:(NSArray *)array bgColor:(UIColor *)bgColor;

/**
 图片组 本地
 @param corner 新生成组合图片背景圆角
 @param array 原生image arr
 @param bgColor 新生成image 背景色
 @return image 组合
 */
+ (UIImage *)groupIconWith:(NSArray *)array corner:(CGFloat)corner bgColor:(UIColor *)bgColor;
/**
 图片组合 网络请求，使用SD缓存到本地磁盘，请求前先去缓存中哈希查找是否有缓存
 
 @param URLArray 图片url 数组
 @param corner 新生成组合图片背景圆角
 @param bgColor 新生成组合图片背景颜色
 @param Success 组合成功回调
 @param Failed 组合失败回调
 */
+ (void )groupIconWithURLArray:(NSArray *)URLArray
                        corner:(CGFloat)corner
                       bgColor:(UIColor *)bgColor
                       Success:(void(^)(UIImage *image))Success
                        Failed:(void(^)(NSString *fail))Failed;
/**
 图片组合 网络请求，使用SD缓存到本地磁盘，请求前先去缓存中哈希查找是否有缓存
 
 @param URLArray 图片url 数组
 @param bgColor 新生成组合图片背景颜色
 @param Success 组合成功回调
 @param Failed 组合失败回调
 */
+ (void)groupIconWithURLArray:(NSArray *)URLArray
                      bgColor:(UIColor *)bgColor
                      Success:(void(^)(UIImage *image))Success
                       Failed:(void(^)(NSString *fail))Failed;

/// 旋转90度
- (UIImage *)normalizedImage;

/// 压缩图片使图片文件小于指定大小
- (NSData *)compressWithMaxLength:(NSUInteger)maxLength;

/**
 缓存图片到SDWebImage
 
 @param url 图片url（如：files/activityPic/xxxx/xxx.jpg）
 */
- (void)cacheImageWithUrl:(NSString *)url;

@end

NS_ASSUME_NONNULL_END
