//
//  ViewControllerConfigure.m
//  CQ_App
//
//  Created by mac on 2019/3/22.
//  Copyright © 2019年 mac. All rights reserved.
//

#import "ViewControllerConfigure.h"
#import "MacroDefinition.h"
#import <Aspects.h>

@implementation ViewControllerConfigure

+(void)load {
    [super load];
    /**
     kDISPATCH_AFTER(0.5, ^{
         [ViewControllerConfigure sharedInstance];
     });
     */
}
+ (instancetype)sharedInstance
{
    static dispatch_once_t onceToken;
    static ViewControllerConfigure *sharedInstance;
    dispatch_once(&onceToken, ^{
        sharedInstance = [[ViewControllerConfigure alloc] init];
    });
    return sharedInstance;
}

- (instancetype)init
{
    self = [super init];
    if (self) {
        /* 在这里做好方法拦截
        [UIViewController aspect_hookSelector:@selector(loadView) withOptions:AspectPositionAfter usingBlock:^(id<AspectInfo>aspectInfo){
            [self loadView:[aspectInfo instance]];
        } error:NULL];*/
        
        [UIViewController aspect_hookSelector:@selector(viewWillAppear:) withOptions:AspectPositionAfter usingBlock:^(id<AspectInfo> aspectInfo, BOOL animated){
            [self viewWillAppear:animated viewController:[aspectInfo instance]];
        } error:NULL];
        
        [UIViewController aspect_hookSelector:@selector(viewDidLoad) withOptions:AspectPositionAfter usingBlock:^(id<AspectInfo> aspectInfo) {
             [self viewDidLoadViewController:[aspectInfo instance]];
        } error:NULL];
        
        /**
        [UIViewController aspect_hookSelector:@selector(viewDidDisappear:) withOptions:AspectPositionAfter usingBlock:^(id<AspectInfo> aspectInfo, BOOL animated){
            [self viewDidDisappear:animated viewController:[aspectInfo instance]];
        } error:NULL];
        
        [UIViewController aspect_hookSelector:@selector(viewDidAppear:) withOptions:AspectPositionAfter usingBlock:^(id<AspectInfo> aspectInfo, BOOL animated){
            [self viewDidAppear:animated viewController:[aspectInfo instance]];
        } error:NULL];*/
        
    }
    return self;
}

/*
 下面的这些方法中就可以做到自动拦截了。
 所以在你原来的架构中，大部分封装UIViewController的基类或者其他的什么基类，都可以使用这种方法让这些基类消失。
 */
#pragma mark - fake methods
- (void)viewDidDisappear:(BOOL)animated viewController:(UIViewController *)viewController {}
- (void)viewDidAppear:(BOOL)animated viewController:(UIViewController *)viewController {}

- (void)viewWillAppear:(BOOL)animated viewController:(UIViewController *)viewController {
    /* 你可以使用这个方法进行打日志，初始化基础业务相关的内容 */
    //NSLog(@"%@ viewWillAppear",viewController.className);
}

- (void)viewDidLoadViewController:(UIViewController *)viewController {
    /* 你可以使用这个方法进行打日志，初始化基础业务相关的内容 */
    //NSLog(@"%@ viewDidLoad",viewController.className);
    [self setupViewsViewController:viewController];
    
    // 判断是否有上级页面，有的话再调用
    
    if ([viewController.navigationController.viewControllers indexOfObject:viewController] > 0) {
        [self setupLeftBarButtonViewController:viewController];
    }
}

- (void)setupViewsViewController:(UIViewController *)viewController {
    // 设置应用的背景色
    if ((![viewController.class isKindOfClass:[UIViewController class]])) {
        viewController.view.backgroundColor = [UIColor whiteColor];
    }
    
}

- (void)setupLeftBarButtonViewController:(UIViewController *)viewController{
    // 自定义 leftBarButtonItem ，UIImageRenderingModeAlwaysOriginal 防止图片被渲染
    viewController.navigationItem.leftBarButtonItem = [[UIBarButtonItem alloc]
                                             initWithImage:[[UIImage imageNamed:@"public_back"] imageWithRenderingMode:UIImageRenderingModeAlwaysOriginal]
                                             style:UIBarButtonItemStylePlain
                                             target:self  action:@selector(leftBarButtonClick)];
}

#pragma mark - 返回按钮的点击事件
- (void)leftBarButtonClick {

    //[[[AppDelegate shareAppDelegate] currentViewController].navigationController popViewControllerAnimated:YES];
}
@end
