//
//  ShoppingCartCell.m
//  Mall-iOS
//
//  Created by Nemo on 2020/10/13.
//

#import "ShoppingCartCell.h"
#import <Masonry/Masonry.h>
#import <NMCategories/NMCategories.h>
#import "CounterView.h"
#import "GoodsModel.h"

@interface ShoppingCartCell ()

@property (nonatomic, strong) UIImageView *selectIv;
@property (nonatomic, strong) UIImageView *goodsIv;
@property (nonatomic, strong) UILabel *goodsNameLb;
@property (nonatomic, strong) UILabel *goodsSpecLb;
@property (nonatomic, strong) UILabel *goodsPriceLb;
@property (nonatomic, strong) CounterView *goodsCounterView;
@end

@implementation ShoppingCartCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier {
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    
    self.selectionStyle = UITableViewCellSelectionStyleNone;

    self.goodsIv.backgroundColor = [UIColor whiteColor];
    self.selectIv.backgroundColor = [UIColor whiteColor];
    
    self.goodsNameLb.text = @"";
    self.goodsSpecLb.text = @"";
    self.goodsPriceLb.text = @"";
    self.goodsCounterView.count = 1;
    
    
}

-(void)setGoodsCountChangeBlock:(void (^)(NSInteger))goodsCountChangeBlock {
    _goodsCountChangeBlock = goodsCountChangeBlock;
    self.goodsCounterView.countChangeAction = goodsCountChangeBlock;
}

- (void)setModel:(GoodsModel *)model {
    _model = model;
    self.goodsNameLb.text = model.goodsName;
    self.goodsSpecLb.text = model.goodsSpec;
    self.goodsPriceLb.text = [NSString stringWithFormat:@"¥%.f",model.goodsPrice];
    self.goodsCounterView.count = model.goodsCount;
    self.selectIv.highlighted = model.isSelect;
}

#pragma mark -- business logic

- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event {
    NSSet *allTouches = [event allTouches];    //返回与当前接收者有关的所有的触摸对象
    UITouch *touch = [allTouches anyObject];   //视图中的所有对象
    CGPoint point = [touch locationInView:self];
    
    if (CGRectContainsPoint(CGRectMake(0, 0, 35,self.bounds.size.height), point)) {
        [self selectAction];
    }else {
        [super touchesBegan:touches withEvent:event];
    }
}

- (void)selectAction {
    self.selectIv.highlighted = !self.selectIv.highlighted;
    !self.selectBlock ?: self.selectBlock(self.selectIv.highlighted);
}

#pragma --mark lazy load


- (CounterView *)goodsCounterView {
    if (_goodsCounterView == nil) {
        _goodsCounterView = [[CounterView alloc] init];
        [self.contentView addSubview:_goodsCounterView];
        [_goodsCounterView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.bottom.equalTo(self.goodsIv);
            make.right.equalTo(self.contentView).inset(27);
            make.size.mas_equalTo(CGSizeMake(94, 30));
        }];
    }
    return _goodsCounterView;
}
- (UILabel *)goodsPriceLb {
    if (_goodsPriceLb == nil) {
        _goodsPriceLb = [[UILabel alloc] init];
        _goodsPriceLb.font = FONTSIZE(12);
        _goodsPriceLb.textColor = RGBCOLOR(40, 40, 40);
        [self.contentView addSubview:_goodsPriceLb];
        [_goodsPriceLb mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.goodsNameLb);
            make.bottom.equalTo(self.goodsIv.mas_bottom).inset(9);
        }];
    }
    return _goodsPriceLb;
}

- (UILabel *)goodsSpecLb {
    if (_goodsSpecLb == nil) {
        _goodsSpecLb = [[UILabel alloc] init];
        _goodsSpecLb.font = FONTSIZE(12);
        _goodsSpecLb.textColor = RGBCOLOR(153, 153, 153);
        [self.contentView addSubview:_goodsSpecLb];
        [_goodsSpecLb mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.goodsNameLb);
            make.top.equalTo(self.goodsNameLb.mas_bottom).offset(7);
        }];
    }
    return _goodsSpecLb;
}

- (UILabel *)goodsNameLb {
    if (_goodsNameLb == nil) {
        _goodsNameLb = [[UILabel alloc] init];
        _goodsNameLb.font = FONTSIZE(13);
        _goodsNameLb.textColor = RGBCOLOR(33, 33, 33);
        [self.contentView addSubview:_goodsNameLb];
        [_goodsNameLb mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.goodsIv.mas_right).offset(8);
            make.top.equalTo(self.goodsIv);
        }];
    }
    return _goodsNameLb;
}

- (UIImageView *)goodsIv {
    if (_goodsIv == nil) {
        _goodsIv = [[UIImageView alloc] init];
        _goodsIv.image = [UIImage imageNamed:@"group_portrait"];
        [self.contentView addSubview:_goodsIv];
        [_goodsIv mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.bottom.equalTo(self).inset(19);
            make.left.equalTo(self.selectIv.mas_right).inset(7);
            make.width.equalTo(self.goodsIv.mas_height).multipliedBy(1);
        }];
    }
    return _goodsIv;
}


- (UIImageView *)selectIv {
    if (_selectIv == nil) {
        _selectIv = [[UIImageView alloc] init];
        _selectIv.image = [UIImage imageNamed:@"check_f"];
        _selectIv.highlightedImage = [UIImage imageNamed:@"check_t"];
        [self.contentView addSubview:_selectIv];
        [_selectIv mas_makeConstraints:^(MASConstraintMaker *make) {
            make.width.height.mas_equalTo(18);
            make.centerY.equalTo(self);
            make.left.mas_equalTo(11);
        }];
    }
    return _selectIv;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
