//
//  ShoppingCartCounterView.m
//  Mall-iOS
//
//  Created by Nemo on 2020/10/13.
//

#import "ShoppingCartCounterView.h"
#import <Masonry/Masonry.h>
#import <NMCategories/NMCategories.h>
#import <QMUIKit.h>

@interface ShoppingCartCounterView()

@property (nonatomic, strong) UIImageView *selectAllIv;
@property (nonatomic, strong) UILabel *selectCountLb;
@property (nonatomic, strong) UILabel *totalPriceLb;
@property (nonatomic, strong) UIButton *paymentBtn;

@end

@implementation ShoppingCartCounterView

- (void)setTotalPrice:(CGFloat)totalPrice {
    _totalPrice = totalPrice;
    self.totalPriceLb.text = [NSString stringWithFormat:@"合计：￥%.f",totalPrice];
}

- (void)setSelectCount:(NSInteger)selectCount {
    _selectCount = selectCount;
    NSString *count = (selectCount == 0)?@"全选":[NSString stringWithFormat:@"已选(%ld)",selectCount];
    self.selectCountLb.text = count;
    
    NSString *paymentStr = (selectCount == 0)?@"结算":[NSString stringWithFormat:@"结算(%ld)",selectCount];

    [self.paymentBtn setTitle:paymentStr forState:UIControlStateNormal];

}

#pragma mark -- business logic

- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event {
    NSSet *allTouches = [event allTouches];    //返回与当前接收者有关的所有的触摸对象
    UITouch *touch = [allTouches anyObject];   //视图中的所有对象
    CGPoint point = [touch locationInView:self];
    
    if (CGRectContainsPoint(CGRectMake(0, 0, 37,self.qmui_height), point)) {
        [self selectAllAction];
    }else {
        [super touchesBegan:touches withEvent:event];
    }
}

- (void)selectAllAction {
    self.selectAllIv.highlighted = !self.selectAllIv.highlighted;
    !self.selectAllBlock ?: self.selectAllBlock(self.selectAllIv.highlighted);
}

- (void)setIsSelectAll:(BOOL)isSelectAll {
    _isSelectAll = isSelectAll;
    self.selectAllIv.highlighted = isSelectAll;
}

- (void)paymentAction {
    !self.orderAction ?: self.orderAction();
}

#pragma --mark lazy load

- (UILabel *)totalPriceLb {
    if (_totalPriceLb == nil) {
        _totalPriceLb = [[UILabel alloc] init];
        _totalPriceLb.textColor = RGBCOLOR(178,37,46);
        [self addSubview:_totalPriceLb];
        [_totalPriceLb mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.equalTo(self.paymentBtn.mas_left).inset(14);
            make.centerY.equalTo(self);
        }];
    }
    return _totalPriceLb;
}

- (UIButton *)paymentBtn {
    if (_paymentBtn == nil) {
        _paymentBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [_paymentBtn setTitle:@"结算" forState:UIControlStateNormal];
        [_paymentBtn setBackgroundColor:RGBCOLOR(178,37,46)];
        [_paymentBtn setTitleColor:QMUICMI.whiteColor forState:UIControlStateNormal];
        [_paymentBtn setTitleColor:QMUICMI.whiteColor forState:UIControlStateHighlighted];
        [_paymentBtn addTarget:self action:@selector(paymentAction) forControlEvents:UIControlEventTouchUpInside];
        [self addSubview:_paymentBtn];
        [_paymentBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.height.mas_equalTo(49);
            make.width.mas_equalTo(110);
            make.right.bottom.equalTo(self);
        }];
    }
    return _paymentBtn;
}

- (UILabel *)selectCountLb {
    if (_selectCountLb == nil) {
        _selectCountLb = [[UILabel alloc] init];
        _selectCountLb.font = FONTSIZE(15);
        [self addSubview:_selectCountLb];
        [_selectCountLb mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.selectAllIv.mas_right).offset(10);
            make.centerY.equalTo(self.selectAllIv);
        }];
    }
    return _selectCountLb;
}

- (UIImageView *)selectAllIv {
    if (_selectAllIv == nil) {
        _selectAllIv = [[UIImageView alloc] init];
        _selectAllIv.image = [UIImage imageNamed:@"check_f"];
        _selectAllIv.highlightedImage = [UIImage imageNamed:@"check_t"];
        [self addSubview:_selectAllIv];
        [_selectAllIv mas_makeConstraints:^(MASConstraintMaker *make) {
            make.width.height.mas_equalTo(18);
            make.centerY.equalTo(self);
            make.left.mas_equalTo(11);
        }];
    }
    return _selectAllIv;
}

@end
