//
//  HomeServices.m
//  Mall-iOS
//
//  Created by Nemo on 2020/10/15.
//

#import "HomeServices.h"
#import <NMNetwork/NMNetwork.h>

@implementation HomeServices

- (RACSignal *)carouselSignal {
    return [RACSignal createSignal:^RACDisposable * _Nullable(id<RACSubscriber>  _Nonnull subscriber) {
        NSURLSessionDataTask *task = [NetworkManager POST:URLShopping() parameters:nil success:^(id  _Nullable responseObject) {
                [subscriber sendNext:responseObject];
                [subscriber sendCompleted];
            } failure:^(id  _Nullable obj, NSError * _Nullable error) {
                [subscriber sendError:error];
            }];
        return [RACDisposable disposableWithBlock:^{
            //完成后清理不需要的资源
            [task cancel];
        }];
    }];
}
@end
