//
//  HomeViewModel.m
//  Mall-iOS
//
//  Created by Nemo on 2020/10/15.
//

#import "HomeViewModel.h"
#import <NMReactiveCocoa/ReactiveObjC.h>
#import "HomeCarouselModel.h"

@interface HomeViewModel()
@property (nonatomic, strong) HomeServices *services;
@end

@implementation HomeViewModel

- (instancetype)initServices:(HomeServices *)services
{
    self = [super init];
    if (self) {
        _services = services;
        _model = [[HomeModel alloc] init];
        _errSubject = [RACSubject subject];
        [self initCommand];
    }
    return self;
}

- (void)initCommand {
    
    @weakify(self);
    self.homeCommand = [[RACCommand alloc] initWithSignalBlock:^RACSignal * _Nonnull(id  _Nullable input) {
        @strongify(self);
        return [[self.services carouselSignal] logAll];
    }];
    
     [self.homeCommand.executionSignals subscribeNext:^(RACSignal* innerSignal) {
         [innerSignal subscribeNext:^(NSArray *x) {
             @strongify(self);
             NSMutableArray *datas = [[NSMutableArray alloc] initWithCapacity:x.count];
             for (NSDictionary *dict in x) {
                 HomeCarouselModel *homeCarouselModel = [HomeCarouselModel homeCarouselModelWithDict:dict];
                 [datas addObject:homeCarouselModel];
             }
             self.model.carouselAraay = datas;
         }];
     }];
    
    [[RACSubject merge:@[self.homeCommand.errors]] subscribe:self.errSubject];
}



-(void)requestData{
//网络请求1
    RACSignal *signal1 = [RACSignal createSignal:^RACDisposable *(id<RACSubscriber> subscriber) {
        NSLog(@"网络请求1");
        [subscriber sendNext:@"网络请求1"];
        return  nil;
    }];
    
//网络请求2
    RACSignal *signal2 = [RACSignal createSignal:^RACDisposable *(id<RACSubscriber> subscriber) {
        NSLog(@"网络请求2");
        [subscriber sendNext:@"网络请求2"];
        return  nil;
    }];
 
//网络请求3
    RACSignal *signal3 = [RACSignal createSignal:^RACDisposable *(id<RACSubscriber> subscriber) {
        NSLog(@"网络请求3");
        [subscriber sendNext:@"网络请求3"];
        return  nil;
    }];
 
    [self rac_liftSelector:@selector(dealDataData1:data2:data3:) withSignals:signal1,signal2,signal3, nil];
}
 
-(void)dealDataData1:(id)data1 data2:(id)data2 data3:(id)data3 {
    
}

@end
