const API_URL = require("../env.js");
import axios from "./request/axios";

/**
 * 初始化网络配置，会覆盖默认配置
 */
function initAxios() {
  const baseUrl = API_URL.host;
  const header = {
    "content-type": "application/x-www-form-urlencoded; charset=UTF-8"
  };
  const transformRequest = data => {
    return {
      /// 这是使用transformRequest给请求参数加上的字段
      //transformRequest: API_URL.xxxx,
      ...data
    };
  };
  const transformResponse = res => ({
    ...res
    // transformResponse: "这是使用transformResponse给response加上的字段"
  });
  const resolveWrap = res => {
    // console.log("resolveWrap:", "这里可以统一处理resolve状态");
    return res.data;
  };
  const rejectWrap = res => {
    // console.log("rejectWrap:", "这里可以统一处理reject状态");
    return res;
  };
  const validateStatus = res => {
    console.log(
      "validateStatus:",
      "使用validateStatus验证请求状态为2xx时才resolve"
    );
    return /^2/.test(res.statusCode.toString());
  };

  axios.creat({
    baseUrl,
    header,
    validateStatus,
    transformRequest,
    transformResponse,
    resolveWrap,
    rejectWrap
  });
}

/**
 * axios的Get请求
 * @param {url} url
 * @param {successCall} 成功回调
 * @param {failCall} 失败回调
 */
function axiosGet(url, successCall, failCall) {
  axios
    .get(url)
    .then(res => {
      //   console.log("发起get请求-res", res);
      successCall && successCall(res);
    })
    .catch(err => {
      //   console.log("发起get请求-err", err);
      failCall && failCall(err);
    });
}

/**
 * axios的Post请求
 * @param {url} url
 * @param {data} 参数
 * @param {successCall} 成功回调
 * @param {failCall} 失败回调
 */
function axiosPost(url, data, successCall, failCall) {
  axios
    .post(url, data)
    .then(res => {
      //   console.log("发起post请求-res", res);
      successCall && successCall(res);
    })
    .catch(err => {
      //   console.log("发起post请求-err", err);
      failCall && failCall(err);
    });
}

module.exports = {
  initAxios,
  axiosGet,
  axiosPost
};
