/**
 *  除继承样式外， app.wxss 中的样式、组件所在页面的的样式对自定义组件无效。
 *  参考文档：https://developers.weixin.qq.com/miniprogram/dev/framework/custom-component/wxml-wxss.html
 *  采用 externalClasses 的方式 在组件.wxml需要的view的class加super-class，可以是多个
 *  使用 <Component super-class="<#type#>" />
 *  也可以使用styleIsolation为shared来使用外部样式
 */
Component({
  properties: {
    //是否可见
    visible: {
      type: Boolean,
      value: true
    },
  },
  options: {
    styleIsolation: 'apply-shared'
  },
  options: {
    multipleSlots: true // 在组件定义时的选项中启用多slot支持
  },
  externalClasses: ["custom-class"],
  data: {},
  methods: {
    // 这里是一个自定义方法
    tagAction(e) {
      this.triggerEvent("tagClick", e);
    }
  }
});
