const readline = require("readline");
const cp = require("child_process");

// cli和项目路径配置
const CONFIG = {
  CLI_PATH:
    process.platform == "win32"
      ? null
      : "/Applications/wechatwebdevtools.app/Contents/MacOS/cli",
  PROJECT_PATH: __dirname + "/dist",
};

// 帮助
// cli -h
function help() {
  const cmd = ` -h`;
  cp.execFile(CONFIG.CLI_PATH, cmd.split(" "), (error, stdout) => {
    console.log(stdout);
  });
}

// 启动IDE
function init() {
  return new Promise((resolve, reject) => {
    cp.execFile(
      CONFIG.CLI_PATH,
      ["--port 3000 -o", CONFIG.PROJECT_PATH],
      (error, stdout) => {
        if (error) {
          console.log("启动IDE失败，请检查配置");
          reject(error);
        }
        console.log(stdout);
        resolve();
      }
    );
  });
}

// 输入项目备注和版本号
function input() {
  return new Promise((resolve, reject) => {
    const rl = readline.createInterface({
      input: process.stdin,
      output: process.stdout,
    });

    rl.question(
      "请输入项目备注和版本号，以空格分隔（例如：测试 1.0.0）： \n",
      (answer) => {
        rl.close();
        if (answer.includes(" ")) {
          const [comment, version] = answer.split(" ");
          console.log("-------");
          console.log("版本号：", version, "，项目备注：", comment);
          resolve({ version, comment });
        } else {
          resolve(input());
        }
      }
    );
  });
}

// 上传体验版
function upload(version, comment) {
  return new Promise((resolve, reject) => {
    // const cmd = ` upload --project ${CONFIG.PROJECT_PATH} -v ${version} -d ${comment} -i ${__dirname}/result.json`
    const cmd = ` -u ${version}@${CONFIG.PROJECT_PATH} --upload-desc ${comment}`;
    cp.execFile(CONFIG.CLI_PATH, cmd.split(" "), (error, stdout) => {
      if (error) {
        console.log("上传失败，请重试");
        reject(error);
      } else {
        console.log(stdout);
        console.log("上传完成");
        resolve(`小程序上传完成:${comment} - 版本号：${version}`);
      }
    });
  });
}

// 提交git信息并加标签
async function gitCommit(version, commit, isUpdateTag = true) {
  cp.execSync("git add .");
  return new Promise((resolve, reject) => {
    cp.exec(`git tag`, (err, stdout) => {
      if (err) {
        reject(err);
      } else {
        const tags = stdout.split("\n");
        resolve(tags[tags.length - 2]);
      }
    });
  })
    .then((tag) => {
      if (tag) {
        const oldTag = tag;
        const [a, b, c] = oldTag.split(".");
        const newTag = isUpdateTag
          ? version && version.length
            ? version
            : [a, b, Number(c) + 1 || 0].join(".")
          : oldTag;
        console.log(
          "旧版本号：",
          oldTag + "，提交版本号：",
          newTag,
          "，提交信息：",
          commit
        );
        return new Promise((resolve, reject) => {
          cp.exec(`git commit -m ${commit}`, (err, stdout) => {
            if (err) {
              console.log(err);
              reject(err);
            } else {
              // if (isUpdateTag) {
              //     cp.execSync(`git tag ${newTag}`)
              // }
              resolve(newTag);
            }
          });
        });
      }
    })
    .catch((err) => {
      console.log("gitcommit 错误");
      throw err;
    });
}

async function main() {
  try {
    const { version, comment } = await input();
    // const newTag = await gitCommit(version, comment)
    const msg = await upload(version, comment);
    console.log("-------");
    console.log(msg);
    console.log("-------");
    console.log("推送完成");
  } catch (e) {
    console.log("e", e);
  }
}

main();
