//app.js
const Request = require("./utils/request.js");
import store from "./store/index";

/**
 * tabBar页面路径列表 (用于链接跳转时判断)
 * tabBarLinks为常量, 无需修改
 */
const tabBarLinks = ["pages/index/index"];

App({
  store: store,
  // 处理无效页面
  onPageNotFound(res) {
    console.log(res);
    wx.switchTab({
      url: "/pages/index/index",
    });
  },
  onLaunch: function () {
    // 初始化axios
    Request.initAxios();

    // 获取设备信息并保存
    this.saveData();

    // 小程序主动更新
    this.updateManager();
  },
  saveData() {
    // 取得设备信息
    try {
      // const res = wx.getSystemInfoSync()
      const that = this;
      wx.getSystemInfo({
        success(res) {
          // 根据不同的手机算出状态栏的高度
          let custom = null;
          try {
            custom = wx.getMenuButtonBoundingClientRect();
            that.globalData.devicePixelRatio = res.devicePixelRatio;
            that.globalData.statusBarHeight = res.statusBarHeight;
            that.globalData.customBarHeight =
              custom.bottom + custom.top - res.statusBarHeight;
            (that.globalData.menuBotton = custom.top - res.statusBarHeight),
              (that.globalData.menuRight = res.screenWidth - custom.right), // 胶囊距右方间距（方保持左、右间距一致）
              (that.globalData.menuHeight = custom.height); // 胶囊高度（自定义内容可与胶囊高度保证一致）
            that.globalData.menuBottonTop =
              custom.top + (custom.height - 32) / 2;
          } catch (e) {
            that.globalData.devicePixelRatio = 1; //res.devicePixelRatio
            that.globalData.statusBarHeight = 20; //res.statusBarHeight
            that.globalData.customBarHeight = 60; //res.statusBarHeight
          }

          if (
            res.screenHeight / res.screenWidth > 2 &&
            res.platform == "android"
          ) {
            that.globalData.isIphoneX = true;
          }

          // console.log('手机信息res' + res.model.search('iPhone X'))
          let modelmes = res.model;
          if (
            modelmes.search("iPhone X") != -1 ||
            modelmes.search("iPhone XR") != -1
          ) {
            that.globalData.isIphoneX = true;
          }

          console.log(res.screenHeight, res.screenWidth, res, "screenWidth");

          // console.log(res)
          if (opts.query.channel && opts.query.channel !== "")
            that.globalData.channel = opts.query.channel;
          // console.log(that.globalData.channel)

          that.globalData.uuid = util.guid();
          wx.setStorageSync("uuid", that.globalData.uuid);
          wx.setStorageSync("systemInfo", JSON.stringify(res));
        },
      });
    } catch (e) {
      // Do something when catch error
    }
  },
  /**
   * 获取tabBar页面路径列表
   */
  getTabBarLinks: function () {
    return tabBarLinks;
  },
  /**
   * 跳转到指定页面,检查登录情况
   * 支持tabBar页面
   */
  checkLoginNavigationTo: function (url, callback) {
    if (this.globalData.userInfo == null) {
      url = "/pages/login/login";
    }
    this.navigationTo(url, callback);
  },
  /**
   * 跳转到指定页面
   * 支持tabBar页面
   */
  navigationTo: function (url, callback) {
    if (!url || url.length == 0) {
      return false;
    }
    let tabBarLinks = this.getTabBarLinks();
    // tabBar页面
    if (tabBarLinks.indexOf(url) > -1) {
      wx.switchTab({
        url: url,
      });
    } else {
      console.log("navigationTo =======" + url);
      // 普通页面
      wx.navigateTo({
        url: url,
      });
    }
    if (callback && typeof callback === "function") {
      this.checkLoginCallback = callback;
    }
  },
  // 更新
  updateManager() {
    if (!wx.canIUse("getUpdateManager")) {
      Tip.toast("当前微信版本过低，无法使用自动更新功能，请升级到最新微信版本");
      return false;
    }
    const updateManager = wx.getUpdateManager();
    updateManager.onCheckForUpdate(function (res) {
      // 请求完新版本信息的回调
      if (res.hasUpdate) {
        console.log("新版本更新");
      }
    });
    updateManager.onUpdateReady(function () {
      wx.showModal({
        title: "更新提示",
        content: "新版本已经准备好，即将重启应用",
        showCancel: false,
        success: function (res) {
          if (res.confirm) {
            // 新的版本已经下载好，调用 applyUpdate 应用新版本并重启
            updateManager.applyUpdate();
          }
        },
      });
    });
    updateManager.onUpdateFailed(function () {
      // 新的版本下载失败
      wx.showModal({
        title: "更新提示",
        content: "新版本下载失败",
        showCancel: false,
      });
    });
  },
  globalData: {
    userInfo: null,
    isIphoneX: false,
    menuBottonTop: 0,
    devicePixelRatio: 1,
    statusBarHeight: 20,
    customBarHeight: 60,
    menuBotton: 0,
    menuRight: 0, // 胶囊距右方间距（方保持左、右间距一致）
    menuHeight: 0,
  },
});
