/**
 * 提示与加载工具类
 */
class Tips {
  constructor() {
    this.isLoading = false;
  }
  /**
   * 弹出提示框
   */

  static success(title, duration = 1500) {
    setTimeout(() => {
      wx.showToast({
        title: title,
        icon: "success",
        mask: true,
        duration: duration,
      });
    }, 500);
    if (duration > 0) {
      return new Promise((resolve, reject) => {
        setTimeout(() => {
          resolve();
        }, duration);
      });
    }
  }

  /**
   * 弹出取消、确认窗口(返回一个promise对象)
   */
  static confirm(text, showCancel = true, title = "提示", payload = {}) {
    return new Promise((resolve, reject) => {
      wx.showModal({
        title: title,
        content: text,
        showCancel: showCancel,
        success: (res) => {
          if (res.confirm) {
            resolve(payload);
          } else if (res.cancel) {
            reject(payload);
          }
        },
        fail: (res) => {
          reject(payload);
        },
      });
    }).catch((e) => {
      console.log(e);
    });
  }
  static toast(title, icon = "none") {
    setTimeout(() => {
      wx.showToast({
        title: String(title),
        icon: icon,
        mask: true,
        duration: 1000,
      });
    }, 300);

    // 隐藏结束回调
    // if (onHide) {
    //   setTimeout(() => {
    //     onHide();
    //   }, 500);
    // }
  }

  /**
   * 警告框
   */
  static alert(title) {
    wx.showToast({
      title: title,
      image: "/static/imges/false.png",
      mask: true,
      duration: 2000,
    });
  }

  /**
   * 错误框
   */

  static error(title, onHide) {
    wx.showToast({
      title: title,
      image: "/static/imges/false.png",
      mask: true,
      duration: 500,
    });
    // 隐藏结束回调
    if (onHide) {
      setTimeout(() => {
        onHide();
      }, 500);
    }
  }

  /**
   * 弹出加载提示
   */
  static loading(title = "加载中") {
    if (Tips.isLoading) {
      return;
    }
    Tips.isLoading = true;
    wx.showLoading({
      title: title,
      mask: true,
    });
  }

  /**
   * 加载完毕
   */
  static loaded() {
    if (Tips.isLoading) {
      Tips.isLoading = false;
      wx.hideLoading();
    }
  }

  static share(title, url, desc) {
    return {
      title: title,
      path: url,
      desc: desc,
      success: function (res) {
        Tips.toast("分享成功");
      },
    };
  }
}

/**
 * 静态变量，是否加载中
 */
Tips.isLoading = false;

module.exports = Tips;
