const formatTime = (date) => {
  const year = date.getFullYear();
  const month = date.getMonth() + 1;
  const day = date.getDate();
  const hour = date.getHours();
  const minute = date.getMinutes();
  const second = date.getSeconds();
  const time = [year, month, day].map(formatNumber).join("/");
  return time + " " + [hour, minute, second].map(formatNumber).join(":");
};

const formatNumber = (n) => {
  n = n.toString();
  return n[1] ? n : "0" + n;
};

const guid = () => {
  function S4() {
    return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
  }

  // return (S4() + S4() + "-" + S4() + "-" + S4() + "-" + S4() + "-" + S4() + S4() + S4());
  return S4() + S4() + S4() + S4() + S4() + S4() + S4() + S4();
};

/**
 * @desc 由经纬度计算两点之间的距离，la为latitude缩写，lo为longitude
 * @param la1 第一个坐标点的纬度
 * @param lo1 第一个坐标点的经度
 * @param la2 第二个坐标点的纬度
 * @param lo2 第二个坐标点的经度
 * @return (int)s   返回距离(单位千米或公里)
 * @tips 注意经度和纬度参数别传反了，一般经度为0~180、纬度为0~90
 */
const distance = (la1, lo1, la2, lo2) => {
  var La1 = (la1 * Math.PI) / 180.0;
  var La2 = (la2 * Math.PI) / 180.0;
  var La3 = La1 - La2;
  var Lb3 = (lo1 * Math.PI) / 180.0 - (lo2 * Math.PI) / 180.0;
  var s =
    2 *
    Math.asin(
      Math.sqrt(
        Math.pow(Math.sin(La3 / 2), 2) +
          Math.cos(La1) * Math.cos(La2) * Math.pow(Math.sin(Lb3 / 2), 2)
      )
    );
  s = s * 6378.137;
  s = Math.round(s * 10000) / 10000;
  s = s.toFixed(2);
  return s;
};

/**
 * @desc 微信小程序腾讯地图坐标和百度地图坐标偏差纠正，lat为latitude缩写，lng为longitude
 * @param lat 坐标点的纬度
 * @param lng 坐标点的经度
 * @return (int)s   返回腾讯地图坐标
 * @tips 注意经度和纬度参数别传反了，一般经度为0~180、纬度为0~90
 */
const convert2TecentMap = (lat, lng) => {
  if (lng == "" && lat == "") {
    return {
      lng: "",
      lat: "",
    };
  }
  var x_pi = (3.14159265358979324 * 3000.0) / 180.0;
  var x = lng - 0.0065;
  var y = lat - 0.006;
  var z = Math.sqrt(x * x + y * y) - 0.00002 * Math.sin(y * x_pi);
  var theta = Math.atan2(y, x) - 0.000003 * Math.cos(x * x_pi);
  var longitude = z * Math.cos(theta);
  var latitude = z * Math.sin(theta);
  return {
    longitude: longitude,
    latitude: latitude,
  };
};

/**
 * @desc hex色值转rgb
 * @param hex hex色值 #eee
 * @return String  RGB色值  0,0,0
 */
const hexToRGB = (hex) => {
  hex = hex + "";
  hex = hex[0] === "#" ? hex.slice(1) : hex;
  hex =
    hex.length === 3
      ? hex[0] + hex[0] + hex[1] + hex[1] + hex[2] + hex[2]
      : hex;
  let res = "";
  if (hex.length !== 6 || !/^[0-9a-fA-F]{6}$/.test(hex)) return null;
  res =
    parseInt(hex[0] + hex[1], 16) +
    ", " +
    parseInt(hex[2] + hex[3], 16) +
    ", " +
    parseInt(hex[4] + hex[5], 16);
  return `${res}`;
};

//返回小程序当前路径和参数
const getCurPagefullPath = () => {
  let pages = getCurrentPages(),
    currPage;
  if (pages.length) {
    currPage = pages[pages.length - 1];
  }
  return "/" + currPage.route;
};

module.exports = {
  formatTime,
  guid,
  distance,
  convert2TecentMap,
  hexToRGB,
  getCurPagefullPath,
};
