//app.js
const Request = require("./utils/request.js");

App({
  // 处理无效页面
  onPageNotFound(res) {
    console.log(res);
    wx.switchTab({
      url: "/pages/index/index",
    });
  },
  onLaunch: function () {
    // 初始化axios
    Request.initAxios();

    // 获取设备信息并保存
    this.saveData();

    // 登录
    wx.login({
      success: (res) => {
        // 发送 res.code 到后台换取 openId, sessionKey, unionId
      },
    });
    // 获取用户信息
    wx.getSetting({
      success: (res) => {
        if (res.authSetting["scope.userInfo"]) {
          // 已经授权，可以直接调用 getUserInfo 获取头像昵称，不会弹框
          wx.getUserInfo({
            success: (res) => {
              // 可以将 res 发送给后台解码出 unionId
              this.globalData.userInfo = res.userInfo;

              // 由于 getUserInfo 是网络请求，可能会在 Page.onLoad 之后才返回
              // 所以此处加入 callback 以防止这种情况
              if (this.userInfoReadyCallback) {
                this.userInfoReadyCallback(res);
              }
            },
          });
        }
      },
    });
  },
  saveData() {
    // 取得设备信息
    try {
      // const res = wx.getSystemInfoSync()
      const that = this;
      wx.getSystemInfo({
        success(res) {
          // 根据不同的手机算出状态栏的高度
          let custom = null;
          try {
            custom = wx.getMenuButtonBoundingClientRect();
            that.globalData.devicePixelRatio = res.devicePixelRatio;
            that.globalData.statusBarHeight = res.statusBarHeight;
            that.globalData.customBarHeight =
              custom.bottom + custom.top - res.statusBarHeight;
            (that.globalData.menuBotton = custom.top - res.statusBarHeight),
              (that.globalData.menuRight = res.screenWidth - custom.right), // 胶囊距右方间距（方保持左、右间距一致）
              (that.globalData.menuHeight = custom.height); // 胶囊高度（自定义内容可与胶囊高度保证一致）
            that.globalData.menuBottonTop =
              custom.top + (custom.height - 32) / 2;
          } catch (e) {
            that.globalData.devicePixelRatio = 1; //res.devicePixelRatio
            that.globalData.statusBarHeight = 20; //res.statusBarHeight
            that.globalData.customBarHeight = 60; //res.statusBarHeight
          }

          if (
            res.screenHeight / res.screenWidth > 2 &&
            res.platform == "android"
          ) {
            that.globalData.isIphoneX = true;
          }

          // console.log('手机信息res' + res.model.search('iPhone X'))
          let modelmes = res.model;
          if (
            modelmes.search("iPhone X") != -1 ||
            modelmes.search("iPhone XR") != -1
          ) {
            that.globalData.isIphoneX = true;
          }

          console.log(res.screenHeight, res.screenWidth, res, "screenWidth");

          // console.log(res)
          if (opts.query.channel && opts.query.channel !== "")
            that.globalData.channel = opts.query.channel;
          // console.log(that.globalData.channel)

          that.globalData.uuid = util.guid();
          wx.setStorageSync("uuid", that.globalData.uuid);
          wx.setStorageSync("systemInfo", JSON.stringify(res));
        },
      });
    } catch (e) {
      // Do something when catch error
    }
  },
  globalData: {
    userInfo: null,
    isIphoneX: false,
    menuBottonTop: 0,
    devicePixelRatio: 1,
    statusBarHeight: 20,
    customBarHeight: 60,
    menuBotton: 0,
    menuRight: 0, // 胶囊距右方间距（方保持左、右间距一致）
    menuHeight: 0,
  },
});
