/**
 *  除继承样式外， app.wxss 中的样式、组件所在页面的的样式对自定义组件无效。
 *  参考文档：https://developers.weixin.qq.com/miniprogram/dev/framework/custom-component/wxml-wxss.html
 *  采用 externalClasses 的方式 在组件.wxml需要的view的class加super-class，可以是多个
 *  使用 <Component super-class="<#type#>" />
 */
Component({
  properties: {
    is: Boolean,
    list: Array,
    title: String // 简化的定义方式
  },
  externalClasses: ["super-class"],
  data: {
    content: "content"
  },
  methods: {
    // 这里是一个自定义方法
    tagAction(e) {
      console.log(e);
      var eventOption = { }; // 触发事件的选项
      this.triggerEvent("tagClick", eventOption);
    }
  }
});
