/**
 *  除继承样式外， app.wxss 中的样式、组件所在页面的的样式对自定义组件无效。
 *  参考文档：https://developers.weixin.qq.com/miniprogram/dev/framework/custom-component/wxml-wxss.html
 *  采用 externalClasses 的方式 在组件.wxml需要的view的class加super-class，可以是多个
 *  使用 <Component super-class="<#type#>" />
 */

let app =  getApp();

Component({
  properties: {
    title: String,
    titleColor: String,
    leftIcon: String,
    titleOpcity: {
      type: Number,
      value: 1
    },
    opcity: {
      type: Number,
      value: 0
    },
    iconOpcity: {
      type: Number,
      value: 0
    }
  },
  externalClasses: ["super-class"],
  data: {
    navBar: 0,
    statusBarHeight: app.globalData.statusBarHeight,
    navBarHeight: 0, // 导航栏高度 = navBar + 状态栏高度
    menuBotton: 0, // 胶囊距底部间距（保持底部间距一致）
    menuRight: 0, // 胶囊距右方间距（方保持左、右间距一致）
    menuHeight: 0 // 胶囊高度（自定义内容可与胶囊高度保证一致）
  },
  pageLifetimes: {
    // 组件所在页面的生命周期函数
    show: function() {

      this.setNavBarInfo();
    }
  },
  methods: {
    /**
     * @description 设置导航栏信息
     */
    setNavBarInfo() {
      this.setData({
        menuBotton: app.globalData.menuBotton,
        menuRight: app.globalData.menuRight, // 胶囊距右方间距（方保持左、右间距一致）
        menuHeight: app.globalData.menuHeight, // 胶囊高度（自定义内容可与胶囊高度保证一致）
        navBar: app.globalData.customBarHeight - app.globalData.statusBarHeight,
        navBarHeight: app.globalData.customBarHeight,
        top: app.globalData.menuBottonTop
      });
    },
    // 这里是一个自定义方法
    tagAction(e) {
      console.log(e);
      var eventOption = { }; // 触发事件的选项
      this.triggerEvent("tagClick", eventOption);
    }
  }
});
