#!/usr/bin/env bash

miniPath=""

if [ -n "$1" ];then
    miniPath=$1
else
    if [ ! -n "$1" ];then
        read -p "请输入要创建的小程序路径:" commitText
        miniPath=$commitText
    else
        miniPath=$1
    fi
fi


if [ ! -d $miniPath ]; then
    echo "########## 找不到小程序的路径，自动创建文件夹 ##########"
    mkdir "$miniPath"
fi

cd $miniPath

echo "########## 开始下载小程序模板 ##########"
# 下载小程序模板
git clone http://git.changein.cn/xzc168520/miniprogramtemplate.git

# 删除下载小程序模板的.git
rm -rf .git

# 移动小程序模板的文件并删除空文件夹
mv ./miniprogramtemplate/** ./
rm -rf miniprogramtemplate

# 初始化 git
git init

echo "########## 初始化小程序npm包 ##########"
cd package
ls

echo "########## 初始化 npm ##########"
# 初始化 npm
npm init -y

echo "########## 安装miniprogram-ci nmaxios ##########"
npm install --save miniprogram-ci nmaxios


echo "########## 小程序根目录 ##########"
cd ..
ls

echo "########## 编译小程序 ##########"
npm run devBuild

echo "########## 生成小程序miniprogram_npm包 ##########"
cd package
miniprogram-ci pack-npm-manually --pack-npm-manually-package-json-path ./package.json --pack-npm-manually-miniprogram-npm-dist-dir ../dist/

cd ..

if ["$(uname)"=="Darwin"];then
    # Mac OS X 操作系统
    /Applications/wechatwebdevtools.app/Contents/MacOS/cli open --project ./dist
    if [ $? -ne 0 ]; then
        echo "########## 打开小程序工具失败 ##########"
        open ./dist
    fi
elif ["$(expr substr $(uname -s) 1 5)"=="Linux"];then
    # GNU/Linux操作系统
echo "########## 双击app.wxss打开小程序 ##########"
    open ./dist
elif ["$(expr substr $(uname -s) 1 10)"=="MINGW32_NT"];then
    # Windows NT操作系统
echo "########## 双击app.wxss打开小程序 ##########"
    open ./dist
fi

echo "########## 开启小程序实时服务 ##########"
npm run dev