#! /bin/sh

miniPath=""

if [ -n "$1" ];then
    miniPath=$1
else
    if [ ! -n "$1" ];then
        read -p "请输入要创建的小程序路径:" commitText
        miniPath=$commitText
    else
        miniPath=$1
    fi
fi

if [ ! -d $miniPath ]; then
    echo "########## 找不到小程序的路径，自动创建文件夹 ##########"
    mkdir "$miniPath"
fi

cd $miniPath

echo "########## 开始下载小程序模板 ##########"
# 下载小程序模板
git clone http://git.changein.cn/xzc168520/miniprogramtemplate.git

# 删除下载小程序模板的.git
rm -rf .git

# 移动小程序模板的文件并删除空文件夹
mv {miniprogramtemplate/*,miniprogramtemplate/.*} ./
rm -rf .DS_Store
rm -rf miniprogramtemplate

echo "########## 输入小程序的appid ##########"
appid="wx238862d8fac4ce23"
read -p "请输入小程序的appid:" commitText

if [ ${#commitText} -eq 18 ];then
    appid=$commitText
else
    echo "########## 小程序的appid输入错误：${appid} ##########"
    cd ..
    rm -rf $miniPath
    exit 127
fi

# 设置小程序的appid
sed "s/\"appid\": \"\"/\"appid\": \"${appid}\"/" project.config.json>project.config.json.bak
rm project.config.json
mv project.config.json.bak project.config.json


echo "########## 安装小程序npm包 ##########"
npm install


echo "########## 进入package文件夹 ##########"
cd package
ls

echo "########## 初始化 npm ##########"
# 初始化 npm
npm init -y

result=`npm list -g --depth 0 miniprogram-ci | grep @`
if [ "${#result}" == 0 ];then
    echo "########## 安装miniprogram-ci ##########"
    npm install --save miniprogram-ci -g
fi

echo "########## 安装 nmaxios ##########"
npm install --save nmaxios

echo "########## 小程序根目录 ##########"
cd ..
ls

echo "########## 编译小程序 ##########"
npm run devBuild

echo "########## 生成小程序miniprogram_npm包 ##########"
cd package
ls
miniprogram-ci pack-npm-manually --pack-npm-manually-package-json-path ./package.json --pack-npm-manually-miniprogram-npm-dist-dir ../dist/ --appid wx238862d8fac4ce23
cd ..

sysOS=`uname -s`
if [ $sysOS == "Darwin" ];then
	 # Mac OS X 操作系统
     open ./dist
    # /Applications/wechatwebdevtools.app/Contents/MacOS/cli open --p ./dist
    if [ $? -ne 0 ]; then
        echo "########## 打开小程序工具失败 ##########"
        open ./dist
    else
        echo "########## 双击app.wxss打开小程序 ##########"
    fi
elif [ $sysOS == "Linux" ];then
    echo "########## 双击app.wxss打开小程序 ##########"
    open ./dist
else
	echo "########## 双击app.wxss打开小程序 ##########"
    open ./dist
fi

# 初始化 git
git init

echo "########## 请自行运行npm run dev命令启动小程序实时服务 ##########"
# 因为gulp dev 会打断 生成miniprogram_mini 暂时手动启动小程序实时服务
# npm run dev